/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.claim;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.plugins.claim.ClaimBuildAction;
import hudson.plugins.claim.ClaimEmailer;
import hudson.plugins.claim.Messages;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;

public final class ClaimPublisher
extends Notifier
implements SimpleBuildStep {
    private static final Logger LOGGER = Logger.getLogger("claim-plugin");

    @DataBoundConstructor
    public ClaimPublisher() {
    }

    public boolean requiresWorkspace() {
        return false;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull EnvVars env, @NonNull TaskListener listener) throws InterruptedException, IOException {
        Result runResult = run.getResult();
        if (runResult != null && runResult.isWorseThan(Result.SUCCESS)) {
            ClaimPublisher.addClaimBuildAction(run);
        }
    }

    static void addClaimBuildAction(Run<?, ?> build) throws IOException {
        ClaimBuildAction c;
        ClaimBuildAction action = new ClaimBuildAction();
        build.addAction((Action)action);
        build.save();
        Run previousBuild = build.getPreviousBuild();
        if (previousBuild != null && (c = (ClaimBuildAction)previousBuild.getAction(ClaimBuildAction.class)) != null && c.isClaimed() && c.isSticky() && c.copyTo(action)) {
            ClaimPublisher.sendEmailsForStickyFailure(build, c.getUserFromId(c.getClaimedBy()));
        }
    }

    private static void sendEmailsForStickyFailure(Run<?, ?> build, User claimedByUser) {
        try {
            ClaimEmailer.sendRepeatedBuildClaimEmailIfConfigured(claimedByUser, build.toString(), build.getUrl());
        }
        catch (MessagingException | IOException e) {
            LOGGER.log(Level.WARNING, "Exception when sending build failure reminder email. Ignoring.", e);
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getHelpFile() {
            return "/plugin/claim/help.html";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.ClaimPublisher_DisplayName();
        }

        public boolean isApplicable(Class jobType) {
            return true;
        }
    }
}

