/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.claim;

import groovy.lang.Binding;
import hudson.model.BuildBadgeAction;
import hudson.model.ProminentProjectAction;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.plugins.claim.ClaimBuildFailureAnalyzer;
import hudson.plugins.claim.ClaimConfig;
import hudson.plugins.claim.CommonMessagesProvider;
import hudson.plugins.claim.DescribableTestAction;
import hudson.security.ACL;
import jakarta.mail.MessagingException;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.verb.POST;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

@ExportedBean(defaultVisibility=2)
public abstract class AbstractClaimBuildAction<T extends Saveable>
extends DescribableTestAction
implements BuildBadgeAction,
ProminentProjectAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger("claim-plugin");
    private boolean claimed;
    private String claimedBy;
    private String assignedBy;
    private Date claimDate;
    private boolean transientClaim = !ClaimConfig.get().isStickyByDefault();
    private ClaimBuildFailureAnalyzer bfaClaimer = null;
    private String reason;

    protected abstract T getOwner();

    AbstractClaimBuildAction() {
    }

    public final CommonMessagesProvider getMessageProvider() {
        return CommonMessagesProvider.build(this);
    }

    public final ClaimBuildFailureAnalyzer getBfaClaimer() {
        return this.bfaClaimer;
    }

    public final String getIconFileName() {
        return null;
    }

    public final String getUrlName() {
        return "claim";
    }

    abstract String getUrl();

    @POST
    public final void doClaim(StaplerRequest2 req, StaplerResponse2 resp) throws Exception {
        User currentUser;
        Jenkins.get().checkPermission(Jenkins.READ);
        User claimedUser = currentUser = AbstractClaimBuildAction.getCurrentUser();
        String assignee = req.getSubmittedForm().getString("assignee");
        if (!StringUtils.isEmpty((String)assignee) && !claimedUser.getId().equals(assignee)) {
            User resolvedAssignee = this.getUserFromId(assignee, false);
            if (resolvedAssignee == null) {
                LOGGER.log(Level.WARNING, "Invalid username specified for assignment: {0}", assignee);
                resp.forwardToPreviousPage(req);
                return;
            }
            claimedUser = resolvedAssignee;
        }
        String reasonProvided = req.getSubmittedForm().getString("reason");
        if (ClaimBuildFailureAnalyzer.isBFAEnabled()) {
            String error = req.getSubmittedForm().getString("errors");
            this.bfaClaimer = new ClaimBuildFailureAnalyzer(error);
            if (this.getOwner() instanceof Run) {
                Run run = (Run)this.getOwner();
                if (!this.bfaClaimer.isDefaultError()) {
                    try {
                        this.bfaClaimer.createFailAction(run);
                    }
                    catch (IndexOutOfBoundsException e) {
                        LOGGER.log(Level.WARNING, "No FailureCauseBuildAction detected for this build");
                        resp.forwardToPreviousPage(req);
                        return;
                    }
                } else {
                    this.bfaClaimer.removeFailAction(run);
                }
            }
        }
        boolean sticky = req.getSubmittedForm().getBoolean("sticky");
        boolean propagated = req.getSubmittedForm().getBoolean("propagateToFollowingBuilds");
        if (StringUtils.isEmpty((String)reasonProvided)) {
            reasonProvided = null;
        }
        this.claim(claimedUser, reasonProvided, currentUser, new Date(), sticky, propagated, true);
        this.getOwner().save();
        this.evalGroovyScript();
        resp.forwardToPreviousPage(req);
    }

    private static User getCurrentUser() {
        Authentication authentication = Jenkins.getAuthentication2();
        return User.get2((Authentication)authentication);
    }

    public final void claim(User claimedByUser, String providedReason, User assignedByUser, Date date, boolean isSticky, boolean isPropagated, boolean notify) {
        this.applyClaim(claimedByUser, providedReason, assignedByUser, date, isSticky, isPropagated);
        if (notify) {
            try {
                this.sendInitialClaimEmail(claimedByUser, providedReason, assignedByUser);
            }
            catch (MessagingException | IOException e) {
                LOGGER.log(Level.WARNING, "Exception encountered sending assignment email: " + e.getMessage());
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "Interrupted when sending assignment email", e);
            }
        }
    }

    protected abstract void sendInitialClaimEmail(User var1, String var2, User var3) throws MessagingException, IOException, InterruptedException;

    protected void applyClaim(@Nonnull User claimedByUser, String providedReason, @Nonnull User assignedByUser, Date date, boolean isSticky, boolean isPropagated) {
        this.claimed = true;
        this.claimedBy = claimedByUser.getId();
        this.reason = providedReason;
        this.transientClaim = !isSticky;
        this.claimDate = date;
        this.assignedBy = assignedByUser.getId();
        if (isPropagated) {
            this.getNextAction().ifPresent(action -> {
                if (!action.isClaimed()) {
                    action.applyClaim(claimedByUser, providedReason, assignedByUser, date, isSticky, true);
                    try {
                        action.getOwner().save();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    protected abstract Optional<AbstractClaimBuildAction> getNextAction();

    @POST
    public final void doUnclaim(StaplerRequest2 req, StaplerResponse2 resp) throws ServletException, IOException {
        Jenkins.get().checkPermission(Jenkins.READ);
        this.unclaim(false);
        if (ClaimBuildFailureAnalyzer.isBFAEnabled() && this.bfaClaimer != null) {
            this.bfaClaimer.removeFailAction((Run)this.getOwner());
        }
        this.getOwner().save();
        this.evalGroovyScript();
        resp.forwardToPreviousPage(req);
    }

    public final void unclaim(boolean notify) {
        this.applyUnclaim();
    }

    protected void applyUnclaim() {
        this.claimed = false;
        this.claimedBy = null;
        this.transientClaim = false;
        this.claimDate = null;
        this.assignedBy = null;
    }

    @Exported
    public final String getClaimedBy() {
        return this.claimedBy;
    }

    @Exported
    public final String getAssignedBy() {
        return this.assignedBy;
    }

    public final String getClaimedByName() {
        User user = this.getUserFromId(this.claimedBy, false);
        if (user != null) {
            return user.getDisplayName();
        }
        return this.claimedBy;
    }

    public final String getAssignedByName() {
        User user = this.getUserFromId(this.assignedBy, false);
        if (user != null) {
            return user.getDisplayName();
        }
        return this.assignedBy;
    }

    public final void setClaimedBy(String claimedBy) {
        this.claimedBy = claimedBy;
    }

    public final void setAssignedBy(String assignedBy) {
        this.assignedBy = assignedBy;
    }

    @Exported
    public final boolean isClaimed() {
        return this.claimed;
    }

    protected boolean copyTo(AbstractClaimBuildAction<T> other) {
        User claimedBy = this.getUserFromId(this.getClaimedBy(), false);
        if (claimedBy == null) {
            return false;
        }
        User assignedBy = this.getUserFromId(this.getAssignedBy(), false);
        if (assignedBy == null) {
            assignedBy = User.getUnknown();
        }
        other.applyClaim(claimedBy, this.getReason(), assignedBy, this.getClaimDate(), this.isSticky(), false);
        return true;
    }

    public final boolean isClaimedByMe() {
        User currentUser = AbstractClaimBuildAction.getCurrentUser();
        if (currentUser != null && currentUser.getId() != null) {
            return currentUser.getId().equals(this.claimedBy);
        }
        return false;
    }

    public final boolean canReassign() {
        return !this.isUserAnonymous() && this.isClaimed();
    }

    public final boolean canClaim() {
        return !this.isUserAnonymous() && !this.isClaimedByMe();
    }

    public final boolean canRelease() {
        return !this.isUserAnonymous() && this.isClaimedByMe();
    }

    protected final boolean isUserAnonymous() {
        return ACL.isAnonymous2((Authentication)Jenkins.getAuthentication2());
    }

    @Exported
    public final String getReason() {
        return this.reason;
    }

    @JavaScriptMethod
    public final String getReason(String error) throws Exception {
        String defaultValue = "";
        if (!ClaimBuildFailureAnalyzer.isBFAEnabled()) {
            return "";
        }
        if (error == null || "Default".equals(error)) {
            return "";
        }
        return ClaimBuildFailureAnalyzer.getFillReasonMap().getOrDefault(error, "");
    }

    public final void setReason(String reason) {
        this.reason = reason;
    }

    public final boolean hasReason() {
        return !StringUtils.isEmpty((String)this.reason);
    }

    public final boolean isTransientClaim() {
        return this.transientClaim;
    }

    public final void setTransientClaim(boolean transientClaim) {
        this.transientClaim = transientClaim;
    }

    public final boolean isSticky() {
        return !this.transientClaim;
    }

    public final void setSticky(boolean sticky) {
        this.transientClaim = !sticky;
    }

    @Restricted(value={DoNotUse.class})
    public final boolean isPropagateToFollowingBuildsByDefault() {
        return ClaimConfig.get().isPropagateToFollowingBuildsByDefault();
    }

    public final String getError() {
        if (this.bfaClaimer == null) {
            return null;
        }
        return this.bfaClaimer.getError();
    }

    public final boolean isBFAEnabled() {
        return ClaimBuildFailureAnalyzer.isBFAEnabled();
    }

    @Exported
    public final Date getClaimDate() {
        if (this.claimDate == null) {
            return null;
        }
        return (Date)this.claimDate.clone();
    }

    public final boolean hasClaimDate() {
        return this.claimDate != null;
    }

    public boolean isSelfAssigned() {
        boolean ret = true;
        if (!this.isClaimed()) {
            ret = false;
        } else if (this.getClaimedBy() == null) {
            ret = false;
        } else if (!this.getClaimedBy().equals(this.getAssignedBy())) {
            ret = false;
        }
        return ret;
    }

    public abstract String getNoun();

    protected final void evalGroovyScript() {
        ClaimConfig config = ClaimConfig.get();
        if (config.hasGroovyTrigger()) {
            SecureGroovyScript groovyScript = config.getGroovyTrigger();
            Binding binding = new Binding();
            binding.setVariable("action", (Object)this);
            try {
                groovyScript.evaluate(Jenkins.get().getPluginManager().uberClassLoader, binding, TaskListener.NULL);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error evaluating Groovy script", e);
            }
        }
    }

    protected final User getUserFromId(String userId) {
        return this.getUserFromId(userId, true);
    }

    protected final User getUserFromId(String userId, boolean throwIfNotFound) {
        User resolved = User.get((String)userId, (boolean)false, Collections.emptyMap());
        if (resolved == null && throwIfNotFound) {
            throw new UsernameNotFoundException("Unknown user: " + userId);
        }
        return resolved;
    }
}

