/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.claim;

import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.User;
import hudson.plugins.claim.AbstractClaimBuildAction;
import hudson.plugins.claim.ClaimBuildFailureAnalyzer;
import hudson.plugins.claim.ClaimConfig;
import hudson.tasks.Mailer;
import hudson.tasks.junit.TestAction;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.AncestorInPath;

public abstract class DescribableTestAction
extends TestAction
implements Describable<DescribableTestAction> {
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static Comparator<User> idComparator = Comparator.comparing(User::getId);
    private static Comparator<User> fullNameComparator = Comparator.comparing(User::getFullName).thenComparing(idComparator);

    public final Descriptor<DescribableTestAction> getDescriptor() {
        return DESCRIPTOR;
    }

    private static Comparator<? super User> getComparator() {
        if (ClaimConfig.get().isSortUsersByFullName()) {
            return fullNameComparator;
        }
        return idComparator;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<DescribableTestAction> {
        public String getDisplayName() {
            return "Assignee";
        }

        public ListBoxModel doFillAssigneeItems() {
            Jenkins.get().checkPermission(Jenkins.READ);
            ListBoxModel items = new ListBoxModel();
            String currentUserId = Jenkins.getAuthentication2().getName();
            User currentUser = null;
            if (currentUserId != null) {
                currentUser = User.get((String)currentUserId, (boolean)false, Collections.emptyMap());
            }
            if (currentUser != null) {
                items.add(DescriptorImpl.getUserDisplayName(currentUser), currentUser.getId());
            }
            Collection c = User.getAll();
            if (currentUser != null) {
                c.remove(currentUser);
            }
            ArrayList<? super User> l = new ArrayList<User>(c);
            l.sort(DescribableTestAction.getComparator());
            for (User user : l) {
                items.add(DescriptorImpl.getUserDisplayName(user), user.getId());
            }
            return items;
        }

        private static String getUserDisplayName(User user) {
            Mailer.UserProperty mailProperty;
            StringBuilder sb = new StringBuilder(user.getDisplayName());
            if (ClaimConfig.get().isEmailDisplayedForAssigneesList() && (mailProperty = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class)) != null && mailProperty.getEmailAddress() != null) {
                sb.append(String.format(" (%s)", mailProperty.getEmailAddress()));
            }
            return sb.toString();
        }

        public ListBoxModel doFillErrorsItems(@AncestorInPath Run run) throws Exception {
            ListBoxModel items;
            block5: {
                Jenkins.get().checkPermission(Jenkins.READ);
                items = new ListBoxModel();
                if (!ClaimBuildFailureAnalyzer.isBFAEnabled()) break block5;
                LinkedList<String> list = ClaimBuildFailureAnalyzer.getDropdownList();
                AbstractClaimBuildAction action = (AbstractClaimBuildAction)run.getAction(AbstractClaimBuildAction.class);
                if (action == null || action.getBfaClaimer() == null || !action.isClaimed()) {
                    items.add("---None---", "Default");
                    for (String cause : list) {
                        items.add(cause, cause);
                    }
                } else {
                    ClaimBuildFailureAnalyzer bfaClaimer = action.getBfaClaimer();
                    if (!bfaClaimer.isDefaultError()) {
                        items.add(bfaClaimer.getError(), bfaClaimer.getError());
                    }
                    items.add("---None---", "Default");
                    for (String cause : list) {
                        if (cause.equals(bfaClaimer.getError())) continue;
                        items.add(cause, cause);
                    }
                }
            }
            return items;
        }
    }
}

