/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.claim;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.plugins.claim.ClaimEmailer;
import hudson.plugins.claim.ClaimTestAction;
import hudson.plugins.claim.LabelTestAction;
import hudson.plugins.claim.Messages;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.ClassResult;
import hudson.tasks.junit.PackageResult;
import hudson.tasks.junit.TestAction;
import hudson.tasks.junit.TestDataPublisher;
import hudson.tasks.junit.TestObject;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

public class ClaimTestDataPublisher
extends TestDataPublisher {
    private static final Logger LOGGER = Logger.getLogger("claim-plugin");
    private boolean displayClaimActionsInTestResultsTable;

    @DataBoundConstructor
    public ClaimTestDataPublisher(boolean displayClaimActionsInTestResultsTable) {
        this.displayClaimActionsInTestResultsTable = displayClaimActionsInTestResultsTable;
    }

    public boolean isDisplayClaimActionsInTestResultsTable() {
        return this.displayClaimActionsInTestResultsTable;
    }

    public void setDisplayClaimActionsInTestResultsTable(boolean displayClaimActionsInTestResultsTable) {
        this.displayClaimActionsInTestResultsTable = displayClaimActionsInTestResultsTable;
    }

    public Data contributeTestData(Run<?, ?> run, @NonNull FilePath workspace, Launcher launcher, TaskListener listener, TestResult testResult) throws IOException, InterruptedException {
        Data data = new Data(run, this.displayClaimActionsInTestResultsTable);
        HashMap<User, List<CaseResult>> claimedFailuresByUser = new HashMap<User, List<CaseResult>>();
        for (CaseResult result : testResult.getFailedTests()) {
            ClaimTestAction action;
            ClaimTestAction previousAction;
            CaseResult previous = result.getPreviousResult();
            if (previous == null || (previousAction = (ClaimTestAction)((Object)previous.getTestAction(ClaimTestAction.class))) == null || !previousAction.isClaimed() || !previousAction.isSticky() || !previousAction.copyTo(action = new ClaimTestAction(data, result.getId()))) continue;
            data.addClaim(result.getId(), action);
            User user = action.getUserFromId(action.getClaimedBy());
            this.putAsListElement(claimedFailuresByUser, user, result);
        }
        this.sendEmailsForStickyFailuresIfPresent(run, testResult, claimedFailuresByUser);
        return data;
    }

    private <K, V> void putAsListElement(Map<K, List<V>> map, K key, V value) {
        List<V> list = map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
        }
        list.add(value);
        map.put(key, list);
    }

    private void sendEmailsForStickyFailuresIfPresent(Run run, TestResult testResult, Map<User, List<CaseResult>> claimedFailuresByUser) {
        try {
            for (Map.Entry<User, List<CaseResult>> entry : claimedFailuresByUser.entrySet()) {
                String url = Functions.joinPath((String[])new String[]{run.getUrl(), testResult.getParentAction().getUrlName()});
                ClaimEmailer.sendRepeatedTestClaimEmailIfConfigured(entry.getKey(), run.toString(), url, entry.getValue());
            }
        }
        catch (MessagingException | IOException e) {
            LOGGER.log(Level.WARNING, "Exception when sending test failure reminder email. Ignoring.", e);
        }
    }

    public static final class Data
    extends TestResultAction.Data
    implements Saveable {
        private Map<String, ClaimTestAction> claims = new HashMap<String, ClaimTestAction>();
        private final Run<?, ?> build;
        private final boolean displayClaimActionsInTestResultsTable;

        public Data(Run<?, ?> build, boolean displayClaimActionsInTestResultsTable) {
            this.build = build;
            this.displayClaimActionsInTestResultsTable = displayClaimActionsInTestResultsTable;
        }

        public boolean isDisplayClaimActionsInTestResultsTable() {
            return this.displayClaimActionsInTestResultsTable;
        }

        public String getUrl() {
            return this.build.getUrl();
        }

        public Run<?, ?> getBuild() {
            return this.build;
        }

        public List<? extends TestAction> getTestAction(TestObject testObject) {
            String prefix = "junit";
            String id = testObject.getId();
            ClaimTestAction result = this.claims.get(id);
            if (result == null && id.startsWith("junit")) {
                result = this.claims.get(id.substring("junit".length()));
            }
            if (result != null) {
                return Collections.singletonList(result);
            }
            if (testObject instanceof CaseResult) {
                CaseResult cr = (CaseResult)testObject;
                if (!cr.isPassed() && !cr.isSkipped()) {
                    return Collections.singletonList(new ClaimTestAction(this, id));
                }
                return Collections.singletonList(new LabelTestAction(this));
            }
            if (testObject instanceof TestResult || testObject instanceof ClassResult || testObject instanceof PackageResult) {
                return Collections.singletonList(new LabelTestAction(this));
            }
            return Collections.emptyList();
        }

        public void save() throws IOException {
            this.build.save();
        }

        public void addClaim(String testObjectId, ClaimTestAction claim) {
            this.claims.put(testObjectId, claim);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<TestDataPublisher> {
        @NonNull
        public String getDisplayName() {
            return Messages.ClaimTestDataPublisher_DisplayName();
        }
    }
}

