/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.claim;

import hudson.model.User;
import hudson.plugins.claim.ClaimConfig;
import hudson.plugins.claim.ClaimEmailPreference;
import hudson.plugins.claim.messages.InitialBuildClaimMessage;
import hudson.plugins.claim.messages.InitialTestClaimMessage;
import hudson.plugins.claim.messages.RepeatedBuildClaimMessage;
import hudson.plugins.claim.messages.RepeatedTestClaimMessage;
import hudson.tasks.Mailer;
import hudson.tasks.junit.CaseResult;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public final class ClaimEmailer {
    private static final Logger LOGGER = Logger.getLogger("claim-plugin");
    private static final boolean MAILER_LOADED = ClaimEmailer.isMailerLoaded();

    private static boolean isMailerLoaded() {
        boolean ret = true;
        try {
            new Mailer.DescriptorImpl();
        }
        catch (Throwable e) {
            LOGGER.warning("Mailer plugin is not installed. Mailer plugin must be installed if you want to send emails");
            ret = false;
        }
        return ret;
    }

    private ClaimEmailer() {
    }

    public static void sendInitialBuildClaimEmailIfConfigured(@Nonnull User claimedByUser, @Nonnull User assignedByUser, String action, String reason, String url) throws MessagingException, IOException {
        if (ClaimEmailer.isAllowUsersToConfigureEmailPreferences() && !ClaimEmailer.isMailEnabledByUserPreference(claimedByUser, ClaimEmailPreference::isReceiveInitialBuildClaimEmail)) {
            LOGGER.log(Level.FINE, "Initial build claim emails not configured for user {0}", claimedByUser.getDisplayName());
            return;
        }
        ClaimConfig config = ClaimConfig.get();
        if (config.getSendEmails() && MAILER_LOADED) {
            InitialBuildClaimMessage message = new InitialBuildClaimMessage(action, url, reason, claimedByUser.getDisplayName(), assignedByUser.getDisplayName());
            message.send();
        }
    }

    public static void sendInitialTestClaimEmailIfConfigured(@Nonnull User claimedByUser, @Nonnull User assignedByUser, String action, String reason, String url) throws MessagingException, IOException {
        if (ClaimEmailer.isAllowUsersToConfigureEmailPreferences() && !ClaimEmailer.isMailEnabledByUserPreference(claimedByUser, ClaimEmailPreference::isReceiveInitialTestClaimEmail)) {
            LOGGER.log(Level.FINE, "Initial test claim emails not configured for user {0}", claimedByUser.getDisplayName());
            return;
        }
        ClaimConfig config = ClaimConfig.get();
        if (config.getSendEmails() && MAILER_LOADED) {
            InitialTestClaimMessage message = new InitialTestClaimMessage(action, url, reason, claimedByUser.getDisplayName(), assignedByUser.getDisplayName());
            message.send();
        }
    }

    public static void sendRepeatedBuildClaimEmailIfConfigured(@Nonnull User claimedByUser, String action, String url) throws MessagingException, IOException {
        if (ClaimEmailer.isAllowUsersToConfigureEmailPreferences() && !ClaimEmailer.isMailEnabledByUserPreference(claimedByUser, ClaimEmailPreference::isReceiveRepeatedBuildClaimEmail)) {
            LOGGER.log(Level.FINE, "Repeated Build claim emails not configured for user {0}", claimedByUser.getDisplayName());
            return;
        }
        ClaimConfig config = ClaimConfig.get();
        if (config.getSendEmailsForStickyFailures() && MAILER_LOADED) {
            RepeatedBuildClaimMessage message = new RepeatedBuildClaimMessage(action, url, claimedByUser.getDisplayName());
            message.send();
        }
    }

    public static void sendRepeatedTestClaimEmailIfConfigured(@Nonnull User claimedByUser, String action, String url, List<CaseResult> failedTests) throws MessagingException, IOException {
        if (ClaimEmailer.isAllowUsersToConfigureEmailPreferences() && !ClaimEmailer.isMailEnabledByUserPreference(claimedByUser, ClaimEmailPreference::isReceiveRepeatedTestClaimEmail)) {
            LOGGER.log(Level.FINE, "Repeated test claim emails not configured for user {0}", claimedByUser.getDisplayName());
            return;
        }
        ClaimConfig config = ClaimConfig.get();
        if (config.getSendEmailsForStickyFailures() && MAILER_LOADED) {
            RepeatedTestClaimMessage message = new RepeatedTestClaimMessage(action, url, claimedByUser.getDisplayName(), failedTests);
            message.send();
        }
    }

    private static boolean isAllowUsersToConfigureEmailPreferences() {
        ClaimConfig config = ClaimConfig.get();
        if (config == null) {
            return false;
        }
        return config.isAllowUsersToConfigureEmailPreferences();
    }

    private static boolean isMailEnabledByUserPreference(@Nonnull User user, EmailPreferenceChecker preferenceChecker) {
        ClaimEmailPreference preference = (ClaimEmailPreference)user.getProperty(ClaimEmailPreference.class);
        if (preference == null) {
            return true;
        }
        return preferenceChecker.shouldSend(preference);
    }

    @FunctionalInterface
    private static interface EmailPreferenceChecker {
        public boolean shouldSend(ClaimEmailPreference var1);
    }
}

