// CHECKSTYLE:OFF

package hudson.plugins.claim;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code ClaimEmailer.Test.Initial.Text}: {@code Test {0} was
     * assigned to you by {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Test {0} was assigned to you by {1}.}
     */
    public static String ClaimEmailer_Test_Initial_Text(Object arg0, Object arg1) {
        return holder.format("ClaimEmailer.Test.Initial.Text", arg0, arg1);
    }

    /**
     * Key {@code ClaimEmailer.Test.Initial.Text}: {@code Test {0} was
     * assigned to you by {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Test {0} was assigned to you by {1}.}
     */
    public static Localizable _ClaimEmailer_Test_Initial_Text(Object arg0, Object arg1) {
        return new Localizable(holder, "ClaimEmailer.Test.Initial.Text", arg0, arg1);
    }

    /**
     * Key {@code CommonMessages.NoObject.Assign.Other}: {@code Assigned to
     * {2} by {1}{3,choice,0#|1# on {4,date,medium} {4,time,medium}}{5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, a number.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Assigned to {2} by {1}{3,choice,0#|1# on {4,date,medium}
     *     {4,time,medium}}{5}}
     */
    public static String CommonMessages_NoObject_Assign_Other(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return holder.format("CommonMessages.NoObject.Assign.Other", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code CommonMessages.NoObject.Assign.Other}: {@code Assigned to
     * {2} by {1}{3,choice,0#|1# on {4,date,medium} {4,time,medium}}{5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, a number.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Assigned to {2} by {1}{3,choice,0#|1# on {4,date,medium}
     *     {4,time,medium}}{5}}
     */
    public static Localizable _CommonMessages_NoObject_Assign_Other(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return new Localizable(holder, "CommonMessages.NoObject.Assign.Other", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code ClaimEmailer.Test.Repeated.Subject}: {@code {0} assigned
     * test{0,choice,1#|1<s} still failing for {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code {0} assigned test{0,choice,1#|1<s} still failing for {1}}
     */
    public static String ClaimEmailer_Test_Repeated_Subject(Object arg0, Object arg1) {
        return holder.format("ClaimEmailer.Test.Repeated.Subject", arg0, arg1);
    }

    /**
     * Key {@code ClaimEmailer.Test.Repeated.Subject}: {@code {0} assigned
     * test{0,choice,1#|1<s} still failing for {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code {0} assigned test{0,choice,1#|1<s} still failing for {1}}
     */
    public static Localizable _ClaimEmailer_Test_Repeated_Subject(Object arg0, Object arg1) {
        return new Localizable(holder, "ClaimEmailer.Test.Repeated.Subject", arg0, arg1);
    }

    /**
     * Key {@code CommonMessages.NoObject.Assign.Self}: {@code Assigned to
     * {2} by you{3,choice,0#|1# on {4,date,medium} {4,time,medium}}{5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, a number.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Assigned to {2} by you{3,choice,0#|1# on {4,date,medium}
     *     {4,time,medium}}{5}}
     */
    public static String CommonMessages_NoObject_Assign_Self(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return holder.format("CommonMessages.NoObject.Assign.Self", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code CommonMessages.NoObject.Assign.Self}: {@code Assigned to
     * {2} by you{3,choice,0#|1# on {4,date,medium} {4,time,medium}}{5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, a number.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Assigned to {2} by you{3,choice,0#|1# on {4,date,medium}
     *     {4,time,medium}}{5}}
     */
    public static Localizable _CommonMessages_NoObject_Assign_Self(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return new Localizable(holder, "CommonMessages.NoObject.Assign.Self", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code CommonMessages.Reason}: {@code Reason:}.
     * 
     * @return
     *     {@code Reason:}
     */
    public static String CommonMessages_Reason() {
        return holder.format("CommonMessages.Reason");
    }

    /**
     * Key {@code CommonMessages.Reason}: {@code Reason:}.
     * 
     * @return
     *     {@code Reason:}
     */
    public static Localizable _CommonMessages_Reason() {
        return new Localizable(holder, "CommonMessages.Reason");
    }

    /**
     * Key {@code ClaimPublisher.DisplayName}: {@code Allow broken build
     * claiming}.
     * 
     * @return
     *     {@code Allow broken build claiming}
     */
    public static String ClaimPublisher_DisplayName() {
        return holder.format("ClaimPublisher.DisplayName");
    }

    /**
     * Key {@code ClaimPublisher.DisplayName}: {@code Allow broken build
     * claiming}.
     * 
     * @return
     *     {@code Allow broken build claiming}
     */
    public static Localizable _ClaimPublisher_DisplayName() {
        return new Localizable(holder, "ClaimPublisher.DisplayName");
    }

    /**
     * Key {@code ClaimEmailer.Test.Repeated.Text}: {@code
     * {0,choice,1#A|1<{0}} test{0,choice,1#|1<s} assigned to you
     * {0,choice,1#is|1<are} still failing in {1}:}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code {0,choice,1#A|1<{0}} test{0,choice,1#|1<s} assigned to you
     *     {0,choice,1#is|1<are} still failing in {1}:}
     */
    public static String ClaimEmailer_Test_Repeated_Text(Object arg0, Object arg1) {
        return holder.format("ClaimEmailer.Test.Repeated.Text", arg0, arg1);
    }

    /**
     * Key {@code ClaimEmailer.Test.Repeated.Text}: {@code
     * {0,choice,1#A|1<{0}} test{0,choice,1#|1<s} assigned to you
     * {0,choice,1#is|1<are} still failing in {1}:}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code {0,choice,1#A|1<{0}} test{0,choice,1#|1<s} assigned to you
     *     {0,choice,1#is|1<are} still failing in {1}:}
     */
    public static Localizable _ClaimEmailer_Test_Repeated_Text(Object arg0, Object arg1) {
        return new Localizable(holder, "ClaimEmailer.Test.Repeated.Text", arg0, arg1);
    }

    /**
     * Key {@code CommonMessages.NoObject.Claim.Other}: {@code Claimed by
     * {1}{3,choice,0#|1# on {4,date,medium} {4,time,medium}}{5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, a number.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Claimed by {1}{3,choice,0#|1# on {4,date,medium}
     *     {4,time,medium}}{5}}
     */
    public static String CommonMessages_NoObject_Claim_Other(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return holder.format("CommonMessages.NoObject.Claim.Other", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code CommonMessages.NoObject.Claim.Other}: {@code Claimed by
     * {1}{3,choice,0#|1# on {4,date,medium} {4,time,medium}}{5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, a number.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Claimed by {1}{3,choice,0#|1# on {4,date,medium}
     *     {4,time,medium}}{5}}
     */
    public static Localizable _CommonMessages_NoObject_Claim_Other(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return new Localizable(holder, "CommonMessages.NoObject.Claim.Other", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code Action.Claim}: {@code Claim it}.
     * 
     * @return
     *     {@code Claim it}
     */
    public static String Action_Claim() {
        return holder.format("Action.Claim");
    }

    /**
     * Key {@code Action.Claim}: {@code Claim it}.
     * 
     * @return
     *     {@code Claim it}
     */
    public static Localizable _Action_Claim() {
        return new Localizable(holder, "Action.Claim");
    }

    /**
     * Key {@code ClaimEmailer.Build.Repeated.Subject}: {@code Assigned build
     * still failing: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Assigned build still failing: {0}}
     */
    public static String ClaimEmailer_Build_Repeated_Subject(Object arg0) {
        return holder.format("ClaimEmailer.Build.Repeated.Subject", arg0);
    }

    /**
     * Key {@code ClaimEmailer.Build.Repeated.Subject}: {@code Assigned build
     * still failing: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Assigned build still failing: {0}}
     */
    public static Localizable _ClaimEmailer_Build_Repeated_Subject(Object arg0) {
        return new Localizable(holder, "ClaimEmailer.Build.Repeated.Subject", arg0);
    }

    /**
     * Key {@code ClaimTestDataPublisher.DisplayName}: {@code Allow claiming
     * of failed tests}.
     * 
     * @return
     *     {@code Allow claiming of failed tests}
     */
    public static String ClaimTestDataPublisher_DisplayName() {
        return holder.format("ClaimTestDataPublisher.DisplayName");
    }

    /**
     * Key {@code ClaimTestDataPublisher.DisplayName}: {@code Allow claiming
     * of failed tests}.
     * 
     * @return
     *     {@code Allow claiming of failed tests}
     */
    public static Localizable _ClaimTestDataPublisher_DisplayName() {
        return new Localizable(holder, "ClaimTestDataPublisher.DisplayName");
    }

    /**
     * Key {@code ClaimEmailer.Details}: {@code See {0} for further details}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code See {0} for further details}
     */
    public static String ClaimEmailer_Details(Object arg0) {
        return holder.format("ClaimEmailer.Details", arg0);
    }

    /**
     * Key {@code ClaimEmailer.Details}: {@code See {0} for further details}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code See {0} for further details}
     */
    public static Localizable _ClaimEmailer_Details(Object arg0) {
        return new Localizable(holder, "ClaimEmailer.Details", arg0);
    }

    /**
     * Key {@code ClaimColumn.ColumnCaption}: {@code Claim}.
     * 
     * @return
     *     {@code Claim}
     */
    public static String ClaimColumn_ColumnCaption() {
        return holder.format("ClaimColumn.ColumnCaption");
    }

    /**
     * Key {@code ClaimColumn.ColumnCaption}: {@code Claim}.
     * 
     * @return
     *     {@code Claim}
     */
    public static Localizable _ClaimColumn_ColumnCaption() {
        return new Localizable(holder, "ClaimColumn.ColumnCaption");
    }

    /**
     * Key {@code ClaimEmailer.Test.Repeated.Details}: {@code - {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code - {0}}
     */
    public static String ClaimEmailer_Test_Repeated_Details(Object arg0) {
        return holder.format("ClaimEmailer.Test.Repeated.Details", arg0);
    }

    /**
     * Key {@code ClaimEmailer.Test.Repeated.Details}: {@code - {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code - {0}}
     */
    public static Localizable _ClaimEmailer_Test_Repeated_Details(Object arg0) {
        return new Localizable(holder, "ClaimEmailer.Test.Repeated.Details", arg0);
    }

    /**
     * Key {@code ClaimEmailer.Test.Initial.Subject}: {@code Assignment for
     * test {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Assignment for test {0}}
     */
    public static String ClaimEmailer_Test_Initial_Subject(Object arg0) {
        return holder.format("ClaimEmailer.Test.Initial.Subject", arg0);
    }

    /**
     * Key {@code ClaimEmailer.Test.Initial.Subject}: {@code Assignment for
     * test {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Assignment for test {0}}
     */
    public static Localizable _ClaimEmailer_Test_Initial_Subject(Object arg0) {
        return new Localizable(holder, "ClaimEmailer.Test.Initial.Subject", arg0);
    }

    /**
     * Key {@code CommonMessages.Object.Assign.ToSelf}: {@code {1} assigned
     * this {0} to you{3,choice,0#|1# on {4,date,medium}
     * {4,time,medium}}{5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, a number.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {1} assigned this {0} to you{3,choice,0#|1# on {4,date,medium}
     *     {4,time,medium}}{5}}
     */
    public static String CommonMessages_Object_Assign_ToSelf(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return holder.format("CommonMessages.Object.Assign.ToSelf", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code CommonMessages.Object.Assign.ToSelf}: {@code {1} assigned
     * this {0} to you{3,choice,0#|1# on {4,date,medium}
     * {4,time,medium}}{5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, a number.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {1} assigned this {0} to you{3,choice,0#|1# on {4,date,medium}
     *     {4,time,medium}}{5}}
     */
    public static Localizable _CommonMessages_Object_Assign_ToSelf(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return new Localizable(holder, "CommonMessages.Object.Assign.ToSelf", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code UnclaimedTestFailuresColumn.ColumnCaption}: {@code
     * Unclaimed test failures}.
     * 
     * @return
     *     {@code Unclaimed test failures}
     */
    public static String UnclaimedTestFailuresColumn_ColumnCaption() {
        return holder.format("UnclaimedTestFailuresColumn.ColumnCaption");
    }

    /**
     * Key {@code UnclaimedTestFailuresColumn.ColumnCaption}: {@code
     * Unclaimed test failures}.
     * 
     * @return
     *     {@code Unclaimed test failures}
     */
    public static Localizable _UnclaimedTestFailuresColumn_ColumnCaption() {
        return new Localizable(holder, "UnclaimedTestFailuresColumn.ColumnCaption");
    }

    /**
     * Key {@code CommonMessages.Object.Claim.Self}: {@code You claimed this
     * {0}{3,choice,0#|1# on {4,date,medium} {4,time,medium}}{5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, a number.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You claimed this {0}{3,choice,0#|1# on {4,date,medium}
     *     {4,time,medium}}{5}}
     */
    public static String CommonMessages_Object_Claim_Self(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return holder.format("CommonMessages.Object.Claim.Self", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code CommonMessages.Object.Claim.Self}: {@code You claimed this
     * {0}{3,choice,0#|1# on {4,date,medium} {4,time,medium}}{5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, a number.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You claimed this {0}{3,choice,0#|1# on {4,date,medium}
     *     {4,time,medium}}{5}}
     */
    public static Localizable _CommonMessages_Object_Claim_Self(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return new Localizable(holder, "CommonMessages.Object.Claim.Self", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code ClaimBuildAction.DisplayName}: {@code Claim Build}.
     * 
     * @return
     *     {@code Claim Build}
     */
    public static String ClaimBuildAction_DisplayName() {
        return holder.format("ClaimBuildAction.DisplayName");
    }

    /**
     * Key {@code ClaimBuildAction.DisplayName}: {@code Claim Build}.
     * 
     * @return
     *     {@code Claim Build}
     */
    public static Localizable _ClaimBuildAction_DisplayName() {
        return new Localizable(holder, "ClaimBuildAction.DisplayName");
    }

    /**
     * Key {@code ClaimColumn.DisplayName}: {@code Claim}.
     * 
     * @return
     *     {@code Claim}
     */
    public static String ClaimColumn_DisplayName() {
        return holder.format("ClaimColumn.DisplayName");
    }

    /**
     * Key {@code ClaimColumn.DisplayName}: {@code Claim}.
     * 
     * @return
     *     {@code Claim}
     */
    public static Localizable _ClaimColumn_DisplayName() {
        return new Localizable(holder, "ClaimColumn.DisplayName");
    }

    /**
     * Key {@code CommonMessages.NoObject.Assign.ToSelf}: {@code Assigned to
     * you by {1}{3,choice,0#|1# on {4,date,medium} {4,time,medium}}{5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, a number.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Assigned to you by {1}{3,choice,0#|1# on {4,date,medium}
     *     {4,time,medium}}{5}}
     */
    public static String CommonMessages_NoObject_Assign_ToSelf(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return holder.format("CommonMessages.NoObject.Assign.ToSelf", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code CommonMessages.NoObject.Assign.ToSelf}: {@code Assigned to
     * you by {1}{3,choice,0#|1# on {4,date,medium} {4,time,medium}}{5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, a number.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Assigned to you by {1}{3,choice,0#|1# on {4,date,medium}
     *     {4,time,medium}}{5}}
     */
    public static Localizable _CommonMessages_NoObject_Assign_ToSelf(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return new Localizable(holder, "CommonMessages.NoObject.Assign.ToSelf", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code Action.Reassign}: {@code Reassign the claim}.
     * 
     * @return
     *     {@code Reassign the claim}
     */
    public static String Action_Reassign() {
        return holder.format("Action.Reassign");
    }

    /**
     * Key {@code Action.Reassign}: {@code Reassign the claim}.
     * 
     * @return
     *     {@code Reassign the claim}
     */
    public static Localizable _Action_Reassign() {
        return new Localizable(holder, "Action.Reassign");
    }

    /**
     * Key {@code ClaimEmailer.Reason}: {@code Reason: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Reason: {0}}
     */
    public static String ClaimEmailer_Reason(Object arg0) {
        return holder.format("ClaimEmailer.Reason", arg0);
    }

    /**
     * Key {@code ClaimEmailer.Reason}: {@code Reason: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Reason: {0}}
     */
    public static Localizable _ClaimEmailer_Reason(Object arg0) {
        return new Localizable(holder, "ClaimEmailer.Reason", arg0);
    }

    /**
     * Key {@code CommonMessages.NoObject.Unclaim}: {@code Unclaimed{5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unclaimed{5}}
     */
    public static String CommonMessages_NoObject_Unclaim(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return holder.format("CommonMessages.NoObject.Unclaim", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code CommonMessages.NoObject.Unclaim}: {@code Unclaimed{5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unclaimed{5}}
     */
    public static Localizable _CommonMessages_NoObject_Unclaim(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return new Localizable(holder, "CommonMessages.NoObject.Unclaim", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code ClaimedBuildsReport.DisplayName}: {@code Claim Report}.
     * 
     * @return
     *     {@code Claim Report}
     */
    public static String ClaimedBuildsReport_DisplayName() {
        return holder.format("ClaimedBuildsReport.DisplayName");
    }

    /**
     * Key {@code ClaimedBuildsReport.DisplayName}: {@code Claim Report}.
     * 
     * @return
     *     {@code Claim Report}
     */
    public static Localizable _ClaimedBuildsReport_DisplayName() {
        return new Localizable(holder, "ClaimedBuildsReport.DisplayName");
    }

    /**
     * Key {@code ClaimTestAction.DisplayName}: {@code Claim Test}.
     * 
     * @return
     *     {@code Claim Test}
     */
    public static String ClaimTestAction_DisplayName() {
        return holder.format("ClaimTestAction.DisplayName");
    }

    /**
     * Key {@code ClaimTestAction.DisplayName}: {@code Claim Test}.
     * 
     * @return
     *     {@code Claim Test}
     */
    public static Localizable _ClaimTestAction_DisplayName() {
        return new Localizable(holder, "ClaimTestAction.DisplayName");
    }

    /**
     * Key {@code CommonMessages.Object.Assign.Other}: {@code {1} assigned
     * this {0} to {2}{3,choice,0#|1# on {4,date,medium}
     * {4,time,medium}}{5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, a number.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {1} assigned this {0} to {2}{3,choice,0#|1# on {4,date,medium}
     *     {4,time,medium}}{5}}
     */
    public static String CommonMessages_Object_Assign_Other(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return holder.format("CommonMessages.Object.Assign.Other", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code CommonMessages.Object.Assign.Other}: {@code {1} assigned
     * this {0} to {2}{3,choice,0#|1# on {4,date,medium}
     * {4,time,medium}}{5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, a number.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {1} assigned this {0} to {2}{3,choice,0#|1# on {4,date,medium}
     *     {4,time,medium}}{5}}
     */
    public static Localizable _CommonMessages_Object_Assign_Other(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return new Localizable(holder, "CommonMessages.Object.Assign.Other", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code UnclaimedTestFailuresColumn.DisplayName}: {@code Unclaimed
     * test failures}.
     * 
     * @return
     *     {@code Unclaimed test failures}
     */
    public static String UnclaimedTestFailuresColumn_DisplayName() {
        return holder.format("UnclaimedTestFailuresColumn.DisplayName");
    }

    /**
     * Key {@code UnclaimedTestFailuresColumn.DisplayName}: {@code Unclaimed
     * test failures}.
     * 
     * @return
     *     {@code Unclaimed test failures}
     */
    public static Localizable _UnclaimedTestFailuresColumn_DisplayName() {
        return new Localizable(holder, "UnclaimedTestFailuresColumn.DisplayName");
    }

    /**
     * Key {@code CommonMessages.Object.Claim.Other}: {@code {1} claimed this
     * {0}{3,choice,0#|1# on {4,date,medium} {4,time,medium}}{5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, a number.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {1} claimed this {0}{3,choice,0#|1# on {4,date,medium}
     *     {4,time,medium}}{5}}
     */
    public static String CommonMessages_Object_Claim_Other(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return holder.format("CommonMessages.Object.Claim.Other", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code CommonMessages.Object.Claim.Other}: {@code {1} claimed this
     * {0}{3,choice,0#|1# on {4,date,medium} {4,time,medium}}{5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, a number.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {1} claimed this {0}{3,choice,0#|1# on {4,date,medium}
     *     {4,time,medium}}{5}}
     */
    public static Localizable _CommonMessages_Object_Claim_Other(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return new Localizable(holder, "CommonMessages.Object.Claim.Other", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code ClaimEmailer.Build.Initial.Subject}: {@code Assignment for
     * build {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Assignment for build {0}}
     */
    public static String ClaimEmailer_Build_Initial_Subject(Object arg0) {
        return holder.format("ClaimEmailer.Build.Initial.Subject", arg0);
    }

    /**
     * Key {@code ClaimEmailer.Build.Initial.Subject}: {@code Assignment for
     * build {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Assignment for build {0}}
     */
    public static Localizable _ClaimEmailer_Build_Initial_Subject(Object arg0) {
        return new Localizable(holder, "ClaimEmailer.Build.Initial.Subject", arg0);
    }

    /**
     * Key {@code CommonMessages.Object.Assign.Self}: {@code You assigned
     * this {0} to {2}{3,choice,0#|1# on {4,date,medium}
     * {4,time,medium}}{5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, a number.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You assigned this {0} to {2}{3,choice,0#|1# on {4,date,medium}
     *     {4,time,medium}}{5}}
     */
    public static String CommonMessages_Object_Assign_Self(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return holder.format("CommonMessages.Object.Assign.Self", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code CommonMessages.Object.Assign.Self}: {@code You assigned
     * this {0} to {2}{3,choice,0#|1# on {4,date,medium}
     * {4,time,medium}}{5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, a number.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You assigned this {0} to {2}{3,choice,0#|1# on {4,date,medium}
     *     {4,time,medium}}{5}}
     */
    public static Localizable _CommonMessages_Object_Assign_Self(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return new Localizable(holder, "CommonMessages.Object.Assign.Self", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code ClaimTestAction.Noun}: {@code test}.
     * 
     * @return
     *     {@code test}
     */
    public static String ClaimTestAction_Noun() {
        return holder.format("ClaimTestAction.Noun");
    }

    /**
     * Key {@code ClaimTestAction.Noun}: {@code test}.
     * 
     * @return
     *     {@code test}
     */
    public static Localizable _ClaimTestAction_Noun() {
        return new Localizable(holder, "ClaimTestAction.Noun");
    }

    /**
     * Key {@code UserClaimsAction.DisplayName.AssignedClaims}: {@code
     * Assigned claims}.
     * 
     * @return
     *     {@code Assigned claims}
     */
    public static String UserClaimsAction_DisplayName_AssignedClaims() {
        return holder.format("UserClaimsAction.DisplayName.AssignedClaims");
    }

    /**
     * Key {@code UserClaimsAction.DisplayName.AssignedClaims}: {@code
     * Assigned claims}.
     * 
     * @return
     *     {@code Assigned claims}
     */
    public static Localizable _UserClaimsAction_DisplayName_AssignedClaims() {
        return new Localizable(holder, "UserClaimsAction.DisplayName.AssignedClaims");
    }

    /**
     * Key {@code Action.PropagateToFollowingBuilds}: {@code Propagate to
     * following builds}.
     * 
     * @return
     *     {@code Propagate to following builds}
     */
    public static String Action_PropagateToFollowingBuilds() {
        return holder.format("Action.PropagateToFollowingBuilds");
    }

    /**
     * Key {@code Action.PropagateToFollowingBuilds}: {@code Propagate to
     * following builds}.
     * 
     * @return
     *     {@code Propagate to following builds}
     */
    public static Localizable _Action_PropagateToFollowingBuilds() {
        return new Localizable(holder, "Action.PropagateToFollowingBuilds");
    }

    /**
     * Key {@code ClaimBuildAction.Noun}: {@code build}.
     * 
     * @return
     *     {@code build}
     */
    public static String ClaimBuildAction_Noun() {
        return holder.format("ClaimBuildAction.Noun");
    }

    /**
     * Key {@code ClaimBuildAction.Noun}: {@code build}.
     * 
     * @return
     *     {@code build}
     */
    public static Localizable _ClaimBuildAction_Noun() {
        return new Localizable(holder, "ClaimBuildAction.Noun");
    }

    /**
     * Key {@code CommonMessages.Object.Unclaim}: {@code This {0} is
     * unclaimed{5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code This {0} is unclaimed{5}}
     */
    public static String CommonMessages_Object_Unclaim(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return holder.format("CommonMessages.Object.Unclaim", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code CommonMessages.Object.Unclaim}: {@code This {0} is
     * unclaimed{5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code This {0} is unclaimed{5}}
     */
    public static Localizable _CommonMessages_Object_Unclaim(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return new Localizable(holder, "CommonMessages.Object.Unclaim", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code Action.Release}: {@code Drop the claim}.
     * 
     * @return
     *     {@code Drop the claim}
     */
    public static String Action_Release() {
        return holder.format("Action.Release");
    }

    /**
     * Key {@code Action.Release}: {@code Drop the claim}.
     * 
     * @return
     *     {@code Drop the claim}
     */
    public static Localizable _Action_Release() {
        return new Localizable(holder, "Action.Release");
    }

    /**
     * Key {@code ClaimEmailer.Build.Initial.Text}: {@code Build {0} was
     * assigned to you by {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Build {0} was assigned to you by {1}.}
     */
    public static String ClaimEmailer_Build_Initial_Text(Object arg0, Object arg1) {
        return holder.format("ClaimEmailer.Build.Initial.Text", arg0, arg1);
    }

    /**
     * Key {@code ClaimEmailer.Build.Initial.Text}: {@code Build {0} was
     * assigned to you by {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Build {0} was assigned to you by {1}.}
     */
    public static Localizable _ClaimEmailer_Build_Initial_Text(Object arg0, Object arg1) {
        return new Localizable(holder, "ClaimEmailer.Build.Initial.Text", arg0, arg1);
    }

    /**
     * Key {@code CommonMessages.NoObject.Claim.Self}: {@code Claimed by
     * you{3,choice,0#|1# on {4,date,medium} {4,time,medium}}{5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, a number.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Claimed by you{3,choice,0#|1# on {4,date,medium}
     *     {4,time,medium}}{5}}
     */
    public static String CommonMessages_NoObject_Claim_Self(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return holder.format("CommonMessages.NoObject.Claim.Self", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code CommonMessages.NoObject.Claim.Self}: {@code Claimed by
     * you{3,choice,0#|1# on {4,date,medium} {4,time,medium}}{5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, a number.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Claimed by you{3,choice,0#|1# on {4,date,medium}
     *     {4,time,medium}}{5}}
     */
    public static Localizable _CommonMessages_NoObject_Claim_Self(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return new Localizable(holder, "CommonMessages.NoObject.Claim.Self", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code UserClaimsAction.DisplayName.MyClaims}: {@code My claims}.
     * 
     * @return
     *     {@code My claims}
     */
    public static String UserClaimsAction_DisplayName_MyClaims() {
        return holder.format("UserClaimsAction.DisplayName.MyClaims");
    }

    /**
     * Key {@code UserClaimsAction.DisplayName.MyClaims}: {@code My claims}.
     * 
     * @return
     *     {@code My claims}
     */
    public static Localizable _UserClaimsAction_DisplayName_MyClaims() {
        return new Localizable(holder, "UserClaimsAction.DisplayName.MyClaims");
    }

}
