/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.claim;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.claim.ClaimTestAction;
import hudson.plugins.claim.Messages;
import hudson.plugins.claim.UnclaimedTestFailuresColumnInformation;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestResult;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public final class UnclaimedTestFailuresColumn
extends ListViewColumn {
    @DataBoundConstructor
    public UnclaimedTestFailuresColumn() {
    }

    public String getColumnCaption() {
        return Messages.UnclaimedTestFailuresColumn_ColumnCaption();
    }

    public UnclaimedTestFailuresColumnInformation getUnclaimedTestsInfo(Job<?, ?> job) {
        AbstractTestResultAction<?> testResultAction = this.getTestResultAction(job);
        UnclaimedTestFailuresColumnInformation info = null;
        if (testResultAction != null) {
            int nbClaimedFailures = 0;
            List failedTests = testResultAction.getFailedTests();
            for (TestResult failedTest : failedTests) {
                ClaimTestAction x = (ClaimTestAction)((Object)failedTest.getTestAction(ClaimTestAction.class));
                if (x == null || !x.isClaimed()) continue;
                ++nbClaimedFailures;
            }
            info = new UnclaimedTestFailuresColumnInformation(testResultAction, nbClaimedFailures);
        }
        return info;
    }

    private AbstractTestResultAction<?> getTestResultAction(Job<?, ?> job) {
        Run run = job.getLastCompletedBuild();
        if (run != null) {
            return (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
        }
        return null;
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public ListViewColumn newInstance(StaplerRequest2 req, @NonNull JSONObject formData) {
            return new UnclaimedTestFailuresColumn();
        }

        @NonNull
        public String getDisplayName() {
            return Messages.UnclaimedTestFailuresColumn_DisplayName();
        }

        public boolean shownByDefault() {
            return false;
        }
    }
}

