/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.claim;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.claim.ClaimBuildAction;
import hudson.plugins.claim.ClaimColumnInformation;
import hudson.plugins.claim.ClaimUtils;
import hudson.plugins.claim.Messages;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public final class ClaimColumn
extends ListViewColumn {
    @DataBoundConstructor
    public ClaimColumn() {
    }

    public String getColumnCaption() {
        return Messages.ClaimColumn_ColumnCaption();
    }

    public List<ClaimColumnInformation> getAction(Job<?, ?> job) {
        ArrayList<ClaimColumnInformation> result = new ArrayList<ClaimColumnInformation>();
        Run run = job.getLastCompletedBuild();
        if (run != null) {
            if (run instanceof MatrixBuild) {
                MatrixBuild matrixBuild = (MatrixBuild)run;
                for (MatrixRun combination : matrixBuild.getRuns()) {
                    Result runResult;
                    ClaimBuildAction action = ClaimUtils.getBuildAction((Run)combination, true);
                    if (action == null || (runResult = combination.getResult()) == null || !runResult.isWorseThan(Result.SUCCESS)) continue;
                    ClaimColumnInformation holder = new ClaimColumnInformation();
                    holder.setClaim(action);
                    holder.setMatrix(true);
                    holder.setCombinationName(combination.getParent().getCombination().toString() + ": ");
                    result.add(holder);
                }
            } else {
                ClaimBuildAction action = ClaimUtils.getBuildAction(run, true);
                if (action != null) {
                    ClaimColumnInformation holder = new ClaimColumnInformation();
                    holder.setClaim(action);
                    result.add(holder);
                }
            }
        }
        return result;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.get().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public ListViewColumn newInstance(StaplerRequest2 req, @NonNull JSONObject formData) throws Descriptor.FormException {
            return new ClaimColumn();
        }

        @NonNull
        public String getDisplayName() {
            return Messages.ClaimColumn_DisplayName();
        }

        public boolean shownByDefault() {
            return false;
        }
    }
}

