/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.categorizedview;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.TopLevelItem;
import org.jenkinsci.plugins.categorizedview.CategorizationCriteria;
import org.jenkinsci.plugins.categorizedview.Utils;
import org.kohsuke.stapler.DataBoundConstructor;

public class GroupingRule
extends CategorizationCriteria {
    private final String groupRegex;
    private final String namingRule;
    private boolean useDisplayName = false;

    @DataBoundConstructor
    public GroupingRule(String groupRegex, String namingRule, boolean useDisplayName) {
        this.groupRegex = groupRegex;
        this.namingRule = namingRule;
        this.useDisplayName = useDisplayName;
    }

    public GroupingRule(String groupRegex, String namingRule) {
        this.groupRegex = groupRegex;
        this.namingRule = namingRule;
        this.useDisplayName = false;
    }

    @Override
    public String groupNameGivenItem(TopLevelItem item) {
        if (!this.isOnGroup(item)) {
            return null;
        }
        String groupNamingRule = this.namingRule == null || this.namingRule.isEmpty() ? "$1" : this.namingRule;
        return this.getItemName(item).replaceAll(this.getNormalizedGroupRegex(), groupNamingRule);
    }

    private boolean isOnGroup(TopLevelItem item) {
        if (this.groupRegex == null || this.groupRegex.isEmpty()) {
            return false;
        }
        return this.getItemName(item).matches(this.getNormalizedGroupRegex());
    }

    private String getItemName(TopLevelItem item) {
        if (!this.useDisplayName) {
            return item.getName();
        }
        if (item.getDisplayName() == null) {
            return item.getName();
        }
        return item.getDisplayName();
    }

    String getNormalizedGroupRegex() {
        return Utils.normalizeRegex(this.getGroupRegex());
    }

    public String getGroupRegex() {
        return this.groupRegex;
    }

    public String getNamingRule() {
        return this.namingRule;
    }

    public boolean getUseDisplayName() {
        return this.useDisplayName;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<CategorizationCriteria> {
        public String getDisplayName() {
            return "Regex Grouping Rule";
        }
    }
}

