/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.categorizedview;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.BallColor;
import hudson.model.HealthReport;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.search.Search;
import hudson.search.SearchIndex;
import hudson.security.ACL;
import hudson.security.Permission;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.categorizedview.TopLevelItemComparator;
import org.springframework.security.access.AccessDeniedException;

public class GroupTopLevelItem
implements TopLevelItem {
    private final String groupName;
    private int nestLevel;
    private final String groupClass;
    protected List<TopLevelItem> nestedItems = new ArrayList<TopLevelItem>();
    private String regexToIgnoreOnColorComputing;
    StringBuilder specificCss = new StringBuilder();

    public GroupTopLevelItem(String groupLabel, String regexToIgnoreOnColorComputing) {
        this.groupName = groupLabel;
        this.regexToIgnoreOnColorComputing = regexToIgnoreOnColorComputing;
        this.nestLevel = 0;
        this.groupClass = "g_" + groupLabel.replaceAll("[^a-zA-Z0-9_]", "_") + groupLabel.hashCode();
        this.specificCss.append("font-weight:bold;");
    }

    public String getName() {
        return this.groupName;
    }

    public String getFullName() {
        return this.groupName;
    }

    public String getDisplayName() {
        return this.groupName;
    }

    public String getFullDisplayName() {
        return this.groupName;
    }

    public void add(TopLevelItem item) {
        this.nestedItems.add(item);
    }

    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
    }

    public void onCopiedFrom(Item src) {
    }

    public void onCreatedFromScratch() {
    }

    public void save() throws IOException {
    }

    public void delete() throws IOException, InterruptedException {
    }

    public void checkPermission(Permission permission) throws AccessDeniedException {
    }

    public BallColor getIconColor() {
        BallColor colorState = BallColor.NOTBUILT;
        for (TopLevelItem item : this.getNestedItems()) {
            if (!(item instanceof Job) || item.getName().matches(this.regexToIgnoreOnColorComputing)) continue;
            BallColor projectColorState = ((Job)item).getIconColor();
            colorState = this.chooseNextColor(colorState, projectColorState);
        }
        return colorState;
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"}, justification="let me just make the 'init' build pass")
    public Run getLastBuild() {
        return this.getLastBuildOfType(new GetBuild(){

            @Override
            public Run getFrom(Job project) {
                return project.getLastBuild();
            }
        });
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"}, justification="let me just make the 'init' build pass")
    public Run getLastSuccessfulBuild() {
        return this.getLastBuildOfType(new GetBuild(){

            @Override
            public Run getFrom(Job project) {
                return project.getLastSuccessfulBuild();
            }
        });
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"}, justification="let me just make the 'init' build pass")
    public Run getLastStableBuild() {
        return this.getLastBuildOfType(new GetBuild(){

            @Override
            public Run getFrom(Job project) {
                return project.getLastStableBuild();
            }
        });
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"}, justification="let me just make the 'init' build pass")
    public Run getLastFailedBuild() {
        return this.getLastBuildOfType(new GetBuild(){

            @Override
            public Run getFrom(Job project) {
                return project.getLastFailedBuild();
            }
        });
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"}, justification="let me just make the 'init' build pass")
    public Run getLastUnsuccessfulBuild() {
        return this.getLastBuildOfType(new GetBuild(){

            @Override
            public Run getFrom(Job project) {
                return project.getLastUnsuccessfulBuild();
            }
        });
    }

    public Run getLastBuildOfType(GetBuild getBuild) {
        Run lastBuild = null;
        for (TopLevelItem item : this.getNestedItems()) {
            if (!(item instanceof Job)) continue;
            Run build = getBuild.getFrom((Job)item);
            if (lastBuild == null) {
                lastBuild = build;
            }
            if (build == null || !build.getTimestamp().getTime().after(lastBuild.getTimestamp().getTime())) continue;
            lastBuild = build;
        }
        return lastBuild;
    }

    public BallColor chooseNextColor(BallColor res, BallColor iconColor) {
        block0 : switch (res) {
            case ABORTED: 
            case ABORTED_ANIME: {
                switch (iconColor) {
                    case YELLOW: 
                    case YELLOW_ANIME: 
                    case RED: 
                    case RED_ANIME: {
                        res = iconColor;
                        break block0;
                    }
                }
                break;
            }
            case BLUE: 
            case BLUE_ANIME: {
                switch (iconColor) {
                    case YELLOW: 
                    case YELLOW_ANIME: 
                    case RED: 
                    case RED_ANIME: 
                    case ABORTED: 
                    case ABORTED_ANIME: {
                        res = iconColor;
                        break block0;
                    }
                }
                break;
            }
            case YELLOW: 
            case YELLOW_ANIME: {
                switch (iconColor) {
                    case RED: 
                    case RED_ANIME: {
                        res = iconColor;
                        break block0;
                    }
                }
                break;
            }
            case RED: 
            case RED_ANIME: {
                break;
            }
            default: {
                res = iconColor;
            }
        }
        return res;
    }

    public String getUrl() {
        return "";
    }

    public String getShortUrl() {
        return "";
    }

    @Deprecated
    public String getAbsoluteUrl() {
        return null;
    }

    public File getRootDir() {
        return null;
    }

    public Search getSearch() {
        return null;
    }

    public String getSearchName() {
        return "";
    }

    public String getSearchUrl() {
        return "";
    }

    public SearchIndex getSearchIndex() {
        return null;
    }

    public ACL getACL() {
        return Jenkins.get().getAuthorizationStrategy().getRootACL();
    }

    public boolean hasPermission(Permission permission) {
        return true;
    }

    public Jenkins getParent() {
        return Jenkins.get();
    }

    public TopLevelItemDescriptor getDescriptor() {
        return null;
    }

    public HealthReport getBuildHealth() {
        HealthReport lowest = new HealthReport();
        lowest.setScore(100);
        for (TopLevelItem e : this.getNestedItems()) {
            HealthReport buildHealth;
            if (!(e instanceof Job) || (buildHealth = ((Job)e).getBuildHealth()).getScore() >= lowest.getScore()) continue;
            lowest = buildHealth;
        }
        return lowest;
    }

    public List<HealthReport> getBuildHealthReports() {
        return null;
    }

    public boolean isBuildable() {
        return false;
    }

    public String getRelativeNameFrom(ItemGroup g) {
        return this.getName();
    }

    public String getRelativeNameFrom(Item item) {
        return this.getName();
    }

    public Collection<? extends Job> getAllJobs() {
        return Collections.emptyList();
    }

    public List<TopLevelItem> getGroupItems() {
        return this.getNestedItems();
    }

    public int getNestLevel() {
        return this.nestLevel;
    }

    public boolean hasLink() {
        return false;
    }

    public String getGroupClass() {
        return this.groupClass;
    }

    public String getCss() {
        StringBuilder builder = this.getBasicCss();
        return builder.toString();
    }

    private StringBuilder getBasicCss() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.specificCss.toString());
        return builder;
    }

    public List<TopLevelItem> getNestedItems() {
        TopLevelItemComparator comparator = new TopLevelItemComparator();
        this.nestedItems.sort(comparator);
        return this.nestedItems;
    }

    static interface GetBuild {
        public Run getFrom(Job var1);
    }
}

