/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.categorizedview;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.ListView;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.model.ViewDescriptor;
import hudson.model.ViewGroup;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jenkinsci.plugins.categorizedview.CategorizationCriteria;
import org.jenkinsci.plugins.categorizedview.CategorizedItemsBuilder;
import org.jenkinsci.plugins.categorizedview.CategorizedJobsListViewColumn;
import org.jenkinsci.plugins.categorizedview.GroupTopLevelItem;
import org.jenkinsci.plugins.categorizedview.GroupingRule;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public class CategorizedJobsView
extends ListView {
    private List<GroupingRule> groupingRules = new ArrayList<GroupingRule>();
    private String regexToIgnoreOnColorComputing = "";
    private DescribableList<CategorizationCriteria, Descriptor<CategorizationCriteria>> categorizationCriteria;
    private transient CategorizedItemsBuilder categorizedItemsBuilder;

    @DataBoundConstructor
    @SuppressFBWarnings(value={"MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR", "UR_UNINIT_READ"}, justification="let me just make the 'init' build pass")
    public CategorizedJobsView(String name) {
        super(name);
        if (this.categorizationCriteria == null) {
            this.categorizationCriteria = new DescribableList((Saveable)this);
        }
        this.migrateOldFormat();
    }

    public CategorizedJobsView(String name, ViewGroup owner) {
        super(name, owner);
    }

    public List<TopLevelItem> getGroupedItems() {
        this.categorizedItemsBuilder = this.categorizationCriteria == null ? new CategorizedItemsBuilder(super.getItems(), this.groupingRules, this.getRegexToIgnoreOnColorComputing()) : new CategorizedItemsBuilder(super.getItems(), this.categorizationCriteria.toList(), this.getRegexToIgnoreOnColorComputing());
        return this.categorizedItemsBuilder.getRegroupedItems();
    }

    public String getRegexToIgnoreOnColorComputing() {
        if (this.regexToIgnoreOnColorComputing == null) {
            return "";
        }
        return this.regexToIgnoreOnColorComputing;
    }

    public void migrateOldFormat() {
        if (this.categorizationCriteria != null) {
            return;
        }
        if (this.groupingRules == null || this.groupingRules.size() == 0) {
            this.categorizationCriteria = new DescribableList((Saveable)this);
        } else {
            this.categorizationCriteria = new DescribableList((Saveable)this, this.groupingRules);
            this.groupingRules.clear();
        }
    }

    protected void submit(StaplerRequest2 req) throws ServletException, Descriptor.FormException, IOException {
        super.submit(req);
        this.categorizationCriteria.rebuildHetero(req, req.getSubmittedForm(), CategorizationCriteria.all(), "categorizationCriteria");
        this.regexToIgnoreOnColorComputing = req.getParameter("regexToIgnoreOnColorComputing");
    }

    public DescribableList<CategorizationCriteria, Descriptor<CategorizationCriteria>> getCategorizationCriteria() {
        this.migrateOldFormat();
        return this.categorizationCriteria;
    }

    public String getGroupClassFor(TopLevelItem item) {
        return this.categorizedItemsBuilder.getGroupClassFor(item);
    }

    public boolean hasLink(TopLevelItem item) {
        return item.getUrl() != null;
    }

    public boolean isGroupTopLevelItem(TopLevelItem item) {
        return item instanceof GroupTopLevelItem;
    }

    protected void initColumns() {
        try {
            Field field = ListView.class.getDeclaredField("columns");
            field.setAccessible(true);
            Object columns = field.get((Object)this);
            if (columns == null) {
                field.set((Object)this, new DescribableList((Saveable)this, CategorizedJobsListViewColumn.createDefaultCategorizedInitialColumnList()));
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends ViewDescriptor {
        public String getDisplayName() {
            return "Categorized Jobs View";
        }

        public FormValidation doCheckIncludeRegex(@QueryParameter String value) {
            String v = Util.fixEmpty((String)value);
            if (v != null) {
                try {
                    Pattern.compile(v);
                }
                catch (PatternSyntaxException pse) {
                    return FormValidation.error((String)pse.getMessage());
                }
            }
            return FormValidation.ok();
        }
    }
}

