/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.categorizedview;

import hudson.model.TopLevelItem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.categorizedview.CategorizationCriteria;
import org.jenkinsci.plugins.categorizedview.GroupTopLevelItem;
import org.jenkinsci.plugins.categorizedview.TopLevelItemComparator;

public class CategorizedItemsBuilder {
    final Comparator<TopLevelItem> comparator = new TopLevelItemComparator();
    private List<TopLevelItem> itemsToCategorize;
    private List<GroupTopLevelItem> groupItems = new ArrayList<GroupTopLevelItem>();
    private List<? extends CategorizationCriteria> groupingRules;
    private Map<String, TopLevelItem> itemsData;
    private String regexToIgnoreOnColorComputing;
    final Map<String, GroupTopLevelItem> groupItemByGroupName = new HashMap<String, GroupTopLevelItem>();

    public CategorizedItemsBuilder(List<TopLevelItem> itemsToCategorize, List<? extends CategorizationCriteria> groupingRules) {
        this(itemsToCategorize, groupingRules, "");
    }

    public CategorizedItemsBuilder(List<TopLevelItem> items, List<? extends CategorizationCriteria> groupingRules, String regexToIgnoreOnColorComputing) {
        this.itemsToCategorize = items;
        this.groupingRules = groupingRules;
        this.regexToIgnoreOnColorComputing = regexToIgnoreOnColorComputing;
    }

    public List<TopLevelItem> getRegroupedItems() {
        return this.buildRegroupedItems();
    }

    private List<TopLevelItem> buildRegroupedItems() {
        return this.flattenList(this.buildCategorizedList());
    }

    private List<TopLevelItem> buildCategorizedList() {
        ArrayList<TopLevelItem> categorizedItems = new ArrayList<TopLevelItem>();
        if (this.groupingRules.size() == 0) {
            categorizedItems.addAll(this.itemsToCategorize);
            return categorizedItems;
        }
        for (TopLevelItem item : this.itemsToCategorize) {
            boolean categorized = this.tryToFitItemInCategory(categorizedItems, item);
            if (categorized) continue;
            categorizedItems.add(item);
        }
        return categorizedItems;
    }

    private boolean tryToFitItemInCategory(List<TopLevelItem> categorizedItems, TopLevelItem item) {
        boolean grouped = false;
        for (CategorizationCriteria categorizationCriteria : this.groupingRules) {
            String groupNameGivenItem = categorizationCriteria.groupNameGivenItem(item);
            if (groupNameGivenItem == null) continue;
            this.addItemToAppropriateGroup(groupNameGivenItem, categorizedItems, item);
            grouped = true;
        }
        return grouped;
    }

    public void addItemToAppropriateGroup(String groupName, List<TopLevelItem> categorizedItems, TopLevelItem item) {
        GroupTopLevelItem groupTopLevelItem = this.getGroupForItemOrCreateIfNeeded(categorizedItems, groupName);
        groupTopLevelItem.add(item);
    }

    private List<TopLevelItem> flattenList(List<TopLevelItem> groupedItems) {
        ArrayList<TopLevelItem> res = new ArrayList<TopLevelItem>();
        this.itemsData = new LinkedHashMap<String, TopLevelItem>();
        groupedItems.sort(this.comparator);
        for (TopLevelItem item : groupedItems) {
            this.addNestedItemsAsIndentedItemsInTheResult(res, item);
        }
        return res;
    }

    private void addNestedItemsAsIndentedItemsInTheResult(ArrayList<TopLevelItem> res, TopLevelItem item) {
        res.add(item);
        this.itemsData.put(item.getName(), item);
    }

    private GroupTopLevelItem getGroupForItemOrCreateIfNeeded(List<TopLevelItem> groupedItems, String groupName) {
        boolean groupIsMissing;
        boolean bl = groupIsMissing = !this.groupItemByGroupName.containsKey(groupName);
        if (groupIsMissing) {
            GroupTopLevelItem value = new GroupTopLevelItem(groupName, this.regexToIgnoreOnColorComputing);
            this.groupItems.add(value);
            this.groupItemByGroupName.put(groupName, value);
            groupedItems.add(this.groupItemByGroupName.get(groupName));
        }
        return this.groupItemByGroupName.get(groupName);
    }

    public String getGroupClassFor(TopLevelItem item) {
        if (item instanceof GroupTopLevelItem) {
            return ((GroupTopLevelItem)item).getGroupClass();
        }
        return "";
    }

    public List<GroupTopLevelItem> getGroupItems() {
        return this.groupItems;
    }
}

