/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.buildtriggerbadge;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import java.util.List;
import org.jenkinsci.plugins.buildtriggerbadge.BuildTriggerBadgeAction;
import org.jenkinsci.plugins.buildtriggerbadge.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class LastBuildTriggerColumn
extends ListViewColumn {
    public static final String ICON_ONLY = "iconOnly";
    public static final String ICON_AND_DESC = "iconAndDesc";
    private final String causeDisplayType;
    @Extension
    public static final Descriptor<ListViewColumn> DESCRIPTOR = new BuildNodeColumnDescriptor();

    @DataBoundConstructor
    public LastBuildTriggerColumn(String causeDisplayType) {
        this.causeDisplayType = causeDisplayType;
    }

    public LastBuildTriggerColumn() {
        this(ICON_ONLY);
    }

    public String getCauseDisplayType() {
        return this.causeDisplayType;
    }

    public Descriptor<ListViewColumn> getDescriptor() {
        return DESCRIPTOR;
    }

    public List<BuildTriggerBadgeAction> getLastBuildCauses(Job<?, ?> job) {
        Run r = job.getLastBuild();
        if (r != null) {
            return BuildTriggerBadgeAction.createForRun(r);
        }
        return null;
    }

    private static final class BuildNodeColumnDescriptor
    extends ListViewColumnDescriptor {
        private BuildNodeColumnDescriptor() {
        }

        @NonNull
        public String getDisplayName() {
            return Messages.LastBuildTriggerColumn_DisplayName();
        }

        public boolean shownByDefault() {
            return false;
        }
    }
}

