/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.buildtriggerbadge;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.cli.BuildCommand;
import hudson.model.Cause;
import hudson.triggers.SCMTrigger;
import hudson.triggers.TimerTrigger;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.buildtriggerbadge.provider.BuildTriggerBadgeProvider;

public class IconFinder {
    private static final Logger LOGGER = Logger.getLogger(IconFinder.class.getName());
    private final Cause cause;
    private static final Map<String, String> DEFAULT_ICONS = new HashMap<String, String>();

    public IconFinder(@NonNull Cause cause) {
        this.cause = cause;
    }

    @NonNull
    public String find() {
        for (BuildTriggerBadgeProvider provider : BuildTriggerBadgeProvider.all()) {
            String providedIcon = provider.provideIcon(this.cause);
            if (providedIcon == null) continue;
            LOGGER.log(Level.FINEST, "Badge for cause '{0}' set/overriden by extension '{1}': '{2}'", new Object[]{this.cause, provider.getClass().getSimpleName(), providedIcon});
            return providedIcon;
        }
        return IconFinder.internalFindForClass(this.cause.getClass());
    }

    @NonNull
    private static String internalFindForClass(Class<?> clazz) {
        if (clazz == null) {
            return "symbol-help-outline plugin-ionicons-api";
        }
        String path = DEFAULT_ICONS.get(clazz.getName());
        if (path == null) {
            return IconFinder.internalFindForClass(clazz.getSuperclass());
        }
        return path;
    }

    private static void defineIconForCause(Class<?> clazz, String path) {
        IconFinder.defineIconForCause(clazz.getName(), path);
    }

    private static void defineIconForCause(String className, String path) {
        DEFAULT_ICONS.put(className, path);
    }

    static {
        IconFinder.defineIconForCause(Cause.UserIdCause.class, "symbol-person-outline plugin-ionicons-api");
        IconFinder.defineIconForCause(Cause.UserCause.class, "symbol-person-outline plugin-ionicons-api");
        IconFinder.defineIconForCause(TimerTrigger.TimerTriggerCause.class, "symbol-time-outline plugin-ionicons-api");
        IconFinder.defineIconForCause(SCMTrigger.SCMTriggerCause.class, "symbol-scm-cause plugin-buildtriggerbadge");
        IconFinder.defineIconForCause(Cause.UpstreamCause.class, "symbol-arrow-up-outline plugin-ionicons-api");
        IconFinder.defineIconForCause(BuildCommand.CLICause.class, "symbol-terminal-outline plugin-ionicons-api");
        IconFinder.defineIconForCause(Cause.RemoteCause.class, "symbol-radio-outline plugin-ionicons-api");
        IconFinder.defineIconForCause("org.jvnet.hudson.plugins.m2release.ReleaseCause", "symbol-person-outline plugin-ionicons-api");
        IconFinder.defineIconForCause("com.cloudbees.jenkins.GitHubPushCause", "symbol-logo-github plugin-ionicons-api");
        IconFinder.defineIconForCause("org.jenkinsci.plugins.ghprb.GhprbCause", "symbol-github-pull-request plugin-ionicons-api");
        IconFinder.defineIconForCause("org.jenkinsci.plugins.github.pullrequest.GitHubPRCause", "symbol-github-pull-request plugin-ionicons-api");
        IconFinder.defineIconForCause("com.cloudbees.jenkins.plugins.github_pull.GitHubPullRequestCause", "symbol-github-pull-request plugin-ionicons-api");
        IconFinder.defineIconForCause("io.jenkins.plugins.checks.github.CheckRunGHEventSubscriber$GitHubChecksRerunActionCause", "symbol-refresh-outline plugin-ionicons-api");
        IconFinder.defineIconForCause("stashpullrequestbuilder.stashpullrequestbuilder.StashCause", "symbol-github-pull-request plugin-ionicons-api");
        IconFinder.defineIconForCause("io.jenkins.plugins.gitlabbranchsource.GitLabMergeRequestCommentCause", "symbol-chatbox-outline plugin-ionicons-api");
        IconFinder.defineIconForCause("com.adobe.jenkins.github_pr_comment_build.GitHubPullRequestCommentCause", "symbol-chatbox-outline plugin-ionicons-api");
        IconFinder.defineIconForCause("org.jenkinsci.plugins.periodicreincarnation.PeriodicReincarnationBuildCause", "symbol-refresh-outline plugin-ionicons-api");
        IconFinder.defineIconForCause("com.chikli.hudson.plugin.naginator.NaginatorCause", "symbol-refresh-outline plugin-ionicons-api");
        IconFinder.defineIconForCause("com.cloudbees.plugins.flow.FlowCause", "symbol-flow-cause plugin-buildtriggerbadge");
        IconFinder.defineIconForCause("com.cloudbees.jenkins.plugins.BitBucketPushCause", "symbol-logo-bitbucket plugin-ionicons-api");
        IconFinder.defineIconForCause("hudson.plugins.git.GitStatus$CommitHookCause", "symbol-git plugin-buildtriggerbadge");
        IconFinder.defineIconForCause("org.jenkinsci.plugins.urltrigger.URLTriggerCause", "symbol-link-outline plugin-ionicons-api");
        IconFinder.defineIconForCause("org.jenkinsci.plugins.gwt.GenericCause", "symbol-link-outline plugin-ionicons-api");
        IconFinder.defineIconForCause("jenkins.branch.BranchIndexingCause", "symbol-branch-indexing-cause plugin-buildtriggerbadge");
        IconFinder.defineIconForCause("jenkins.branch.BranchEventCause", "symbol-git-branch-outline plugin-ionicons-api");
        IconFinder.defineIconForCause("org.jenkinsci.plugins.workflow.cps.replay.ReplayCause", "symbol-refresh-outline plugin-ionicons-api");
        IconFinder.defineIconForCause("org.jenkinsci.lib.xtrigger.XTriggerCause", "symbol-xtrigger plugin-buildtriggerbadge");
        IconFinder.defineIconForCause("com.cloudbees.workflow.cps.checkpoint.RestoreFromCheckpointCause", "symbol-location-outline plugin-ionicons-api");
        IconFinder.defineIconForCause("org.jenkinsci.plugins.parameterizedscheduler.ParameterizedTimerTriggerCause", "symbol-time-outline plugin-ionicons-api");
    }
}

