/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.buildtriggerbadge;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Cause;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections.CollectionUtils;
import org.jenkinsci.plugins.buildtriggerbadge.provider.BuildTriggerBadgeDeactivator;

public class CauseFilter {
    private static final Logger LOGGER = Logger.getLogger(CauseFilter.class.getName());

    @NonNull
    public static List<Cause> filter(@Nullable List<Cause> inputCauses) {
        return CauseFilter.filter(inputCauses, null);
    }

    @NonNull
    public static List<Cause> filter(@Nullable List<Cause> inputCauses, @Nullable List<BuildTriggerBadgeDeactivator> deactivators) {
        if (inputCauses == null) {
            return List.of();
        }
        return inputCauses.stream().filter(CauseFilter.distinctCause()).filter(CauseFilter.notDeactivated(deactivators)).toList();
    }

    private static Predicate<Cause> distinctCause() {
        HashSet seen = new HashSet();
        return c -> seen.add(CauseFilter.getCauseFilter(c));
    }

    private static String getCauseFilter(Cause cause) {
        return cause.getClass().getCanonicalName() + "_" + cause.getShortDescription();
    }

    private static Predicate<Cause> notDeactivated(@Nullable List<BuildTriggerBadgeDeactivator> deactivators) {
        if (CollectionUtils.isEmpty(deactivators)) {
            return cause -> true;
        }
        return cause -> {
            for (BuildTriggerBadgeDeactivator deactivator : deactivators) {
                if (!deactivator.vetoBadge((Cause)cause)) continue;
                LOGGER.log(Level.FINE, "Badge for cause '{0}' disabled by extension '{1}'", new Object[]{cause, deactivator});
                return false;
            }
            return true;
        };
    }
}

