/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.buildtriggerbadge;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.BuildBadgeAction;
import hudson.model.Cause;
import hudson.model.Run;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.buildtriggerbadge.BuildTriggerBadgePlugin;
import org.jenkinsci.plugins.buildtriggerbadge.CauseFilter;
import org.jenkinsci.plugins.buildtriggerbadge.IconFinder;
import org.jenkinsci.plugins.buildtriggerbadge.provider.BuildTriggerBadgeDeactivator;

public class BuildTriggerBadgeAction
implements BuildBadgeAction {
    private final Cause cause;

    @NonNull
    static List<BuildTriggerBadgeAction> createForRun(@NonNull Run<?, ?> run) {
        return CauseFilter.filter(run.getCauses(), BuildTriggerBadgeDeactivator.all()).stream().map(BuildTriggerBadgeAction::new).toList();
    }

    public BuildTriggerBadgeAction(@NonNull Cause cause) {
        this.cause = cause;
    }

    public String getTooltip() {
        return this.cause.getShortDescription();
    }

    public static BuildTriggerBadgePlugin getPlugin() {
        return (BuildTriggerBadgePlugin)Jenkins.get().getPlugin(BuildTriggerBadgePlugin.class);
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return "Trigger " + this.cause.getClass().getSimpleName() + " : " + this.getTooltip();
    }

    public String getUrlName() {
        return "";
    }

    public String getIcon() {
        return new IconFinder(this.cause).find();
    }
}

