/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.buildwithparameters;

import hudson.model.Action;
import hudson.model.BooleanParameterDefinition;
import hudson.model.BooleanParameterValue;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.ChoiceParameterDefinition;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.PasswordParameterDefinition;
import hudson.model.PasswordParameterValue;
import hudson.model.Queue;
import hudson.model.StringParameterDefinition;
import hudson.model.TextParameterDefinition;
import hudson.util.Secret;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.buildwithparameters.BuildParameter;
import org.jenkinsci.plugins.buildwithparameters.BuildParameterType;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class BuildWithParametersAction<T extends Job<?, ?>>
implements Action {
    private static final String URL_NAME = "parambuild";
    private final T project;

    public BuildWithParametersAction(T project) {
        this.project = project;
    }

    public String getProjectName() {
        return this.project.getName();
    }

    public List<BuildParameter> getAvailableParameters() {
        ArrayList<BuildParameter> buildParameters = new ArrayList<BuildParameter>();
        for (ParameterDefinition parameterDefinition : this.getParameterDefinitions()) {
            BuildParameter buildParameter = new BuildParameter(parameterDefinition.getName(), parameterDefinition.getDescription());
            if (parameterDefinition.getClass().isAssignableFrom(PasswordParameterDefinition.class)) {
                buildParameter.setType(BuildParameterType.PASSWORD);
            } else if (parameterDefinition.getClass().isAssignableFrom(BooleanParameterDefinition.class)) {
                buildParameter.setType(BuildParameterType.BOOLEAN);
            } else if (parameterDefinition.getClass().isAssignableFrom(ChoiceParameterDefinition.class)) {
                buildParameter.setType(BuildParameterType.CHOICE);
                buildParameter.setChoices(((ChoiceParameterDefinition)parameterDefinition).getChoices());
            } else if (parameterDefinition.getClass().isAssignableFrom(StringParameterDefinition.class)) {
                buildParameter.setType(BuildParameterType.STRING);
            } else if (parameterDefinition.getClass().isAssignableFrom(TextParameterDefinition.class)) {
                buildParameter.setType(BuildParameterType.TEXT);
            } else {
                buildParameter.setType(BuildParameterType.STRING);
            }
            try {
                buildParameter.setValue(this.getParameterDefinitionValue(parameterDefinition));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            buildParameters.add(buildParameter);
        }
        return buildParameters;
    }

    ParameterValue getParameterDefinitionValue(ParameterDefinition parameterDefinition) {
        return parameterDefinition.createValue(Stapler.getCurrentRequest2());
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        this.project.checkPermission(BuildableItem.BUILD);
        return URL_NAME;
    }

    @RequirePOST
    public void doConfigSubmit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        this.project.checkPermission(BuildableItem.BUILD);
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
        JSONObject formData = req.getSubmittedForm();
        if (!formData.isEmpty()) {
            for (ParameterDefinition parameterDefinition : this.getParameterDefinitions()) {
                ParameterValue parameterValue = parameterDefinition.createValue(req);
                if (parameterValue != null) {
                    if (parameterValue.getClass().isAssignableFrom(BooleanParameterValue.class)) {
                        boolean value = req.getParameter(parameterDefinition.getName()) != null;
                        parameterValue = ((BooleanParameterDefinition)parameterDefinition).createValue(String.valueOf(value));
                    } else if (parameterValue.getClass().isAssignableFrom(PasswordParameterValue.class)) {
                        parameterValue = this.applyDefaultPassword((PasswordParameterDefinition)parameterDefinition, (PasswordParameterValue)parameterValue);
                    }
                }
                values.add(parameterValue);
            }
        }
        Jenkins.get().getQueue().schedule((Queue.Task)this.project, 0, new Action[]{new ParametersAction(values), new CauseAction((Cause)new Cause.UserIdCause())});
        rsp.sendRedirect("../");
    }

    ParameterValue applyDefaultPassword(PasswordParameterDefinition parameterDefinition, PasswordParameterValue parameterValue) {
        String jobPassword = BuildWithParametersAction.getPasswordValue(parameterValue);
        if (!BuildParameter.isDefaultPasswordPlaceholder(jobPassword)) {
            return parameterValue;
        }
        PasswordParameterValue password = (PasswordParameterValue)parameterDefinition.getDefaultParameterValue();
        String jobDefaultPassword = password != null ? BuildWithParametersAction.getPasswordValue(password) : "";
        return new PasswordParameterValue(parameterValue.getName(), jobDefaultPassword);
    }

    static String getPasswordValue(PasswordParameterValue parameterValue) {
        Secret secret = parameterValue.getValue();
        return Secret.toString((Secret)secret);
    }

    private List<ParameterDefinition> getParameterDefinitions() {
        ParametersDefinitionProperty property = (ParametersDefinitionProperty)this.project.getProperty(ParametersDefinitionProperty.class);
        if (property != null && property.getParameterDefinitions() != null) {
            return property.getParameterDefinitions();
        }
        return new ArrayList<ParameterDefinition>();
    }
}

