/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.buildwithparameters;

import hudson.model.Action;
import hudson.model.BooleanParameterDefinition;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.ChoiceParameterDefinition;
import hudson.model.FileParameterDefinition;
import hudson.model.FileParameterValue;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.PasswordParameterDefinition;
import hudson.model.PasswordParameterValue;
import hudson.model.Queue;
import hudson.model.StringParameterDefinition;
import hudson.model.TextParameterDefinition;
import hudson.util.Secret;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.fileupload.FileItem;
import org.jenkinsci.plugins.buildwithparameters.BuildParameter;
import org.jenkinsci.plugins.buildwithparameters.BuildParameterType;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class BuildWithParametersAction<T extends Job<?, ?>>
implements Action {
    private static final String URL_NAME = "parambuild";
    private static final Logger LOG = Logger.getLogger(BuildWithParametersAction.class.getName());
    private final T project;

    public BuildWithParametersAction(T project) {
        this.project = project;
    }

    public String getProjectName() {
        return this.project.getName();
    }

    public List<BuildParameter> getAvailableParameters() {
        ArrayList<BuildParameter> buildParameters = new ArrayList<BuildParameter>();
        for (ParameterDefinition parameterDefinition : this.getParameterDefinitions()) {
            BuildParameter buildParameter = new BuildParameter(parameterDefinition.getName(), parameterDefinition.getDescription());
            if (parameterDefinition.getClass().isAssignableFrom(PasswordParameterDefinition.class)) {
                buildParameter.setType(BuildParameterType.PASSWORD);
            } else if (parameterDefinition.getClass().isAssignableFrom(BooleanParameterDefinition.class)) {
                buildParameter.setType(BuildParameterType.BOOLEAN);
            } else if (parameterDefinition.getClass().isAssignableFrom(ChoiceParameterDefinition.class)) {
                buildParameter.setType(BuildParameterType.CHOICE);
                buildParameter.setChoices(((ChoiceParameterDefinition)parameterDefinition).getChoices());
            } else if (parameterDefinition.getClass().isAssignableFrom(StringParameterDefinition.class)) {
                buildParameter.setType(BuildParameterType.STRING);
            } else if (parameterDefinition.getClass().isAssignableFrom(TextParameterDefinition.class)) {
                buildParameter.setType(BuildParameterType.TEXT);
            } else if (parameterDefinition.getClass().isAssignableFrom(FileParameterDefinition.class)) {
                buildParameter.setType(BuildParameterType.FILE);
            } else {
                buildParameter.setType(BuildParameterType.STRING);
            }
            try {
                if (buildParameter.getType() != BuildParameterType.FILE) {
                    ParameterValue parameterValue = this.getParameterDefinitionValue(parameterDefinition);
                    buildParameter.setValue(parameterValue);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            buildParameters.add(buildParameter);
        }
        return buildParameters;
    }

    ParameterValue getParameterDefinitionValue(ParameterDefinition parameterDefinition) {
        return parameterDefinition.createValue(Stapler.getCurrentRequest());
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        this.project.checkPermission(BuildableItem.BUILD);
        return URL_NAME;
    }

    @RequirePOST
    public void doConfigSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.project.checkPermission(BuildableItem.BUILD);
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
        JSONObject formData = req.getSubmittedForm();
        if (!formData.isEmpty()) {
            for (ParameterDefinition parameterDefinition : this.getParameterDefinitions()) {
                ParameterValue parameterValue = parameterDefinition.createValue(req);
                if (parameterDefinition.getClass().isAssignableFrom(BooleanParameterDefinition.class)) {
                    boolean value = req.getParameter(parameterDefinition.getName()) != null;
                    parameterValue = ((BooleanParameterDefinition)parameterDefinition).createValue(String.valueOf(value));
                } else if (parameterDefinition.getClass().isAssignableFrom(PasswordParameterDefinition.class)) {
                    parameterValue = this.applyDefaultPassword((PasswordParameterDefinition)parameterDefinition, (PasswordParameterValue)parameterValue);
                } else if (parameterDefinition.getClass().isAssignableFrom(FileParameterDefinition.class)) {
                    parameterValue = this.resolveFileParameter(req, formData, (FileParameterDefinition)parameterDefinition);
                }
                values.add(parameterValue);
            }
        }
        Jenkins.get().getQueue().schedule((Queue.Task)this.project, 0, new Action[]{new ParametersAction(values), new CauseAction((Cause)new Cause.UserIdCause())});
        rsp.sendRedirect("../");
    }

    ParameterValue resolveFileParameter(StaplerRequest req, JSONObject formData, FileParameterDefinition def) throws ServletException, IOException {
        JSONArray jsonArray;
        if (req == null) {
            return null;
        }
        Object paramObj = formData.get("parameter");
        if (paramObj instanceof JSONArray) {
            jsonArray = (JSONArray)paramObj;
        } else if (paramObj instanceof JSONObject) {
            jsonArray = new JSONArray();
            jsonArray.add(paramObj);
        } else {
            jsonArray = new JSONArray();
        }
        String parameterName = def.getName();
        for (Object jsonArrayItem : jsonArray) {
            JSONObject jsonObj = (JSONObject)jsonArrayItem;
            if (!jsonObj.has("name") || !jsonObj.getString("name").equals(parameterName)) continue;
            String fileName = jsonObj.getString("");
            FileItem fileItem = req.getFileItem(fileName);
            FileParameterValue fileParameterValue = new FileParameterValue(parameterName, fileItem);
            fileParameterValue.setDescription(def.getDescription());
            return fileParameterValue;
        }
        return null;
    }

    ParameterValue applyDefaultPassword(PasswordParameterDefinition parameterDefinition, PasswordParameterValue parameterValue) {
        String jobPassword = BuildWithParametersAction.getPasswordValue(parameterValue);
        if (!BuildParameter.isDefaultPasswordPlaceholder(jobPassword)) {
            return parameterValue;
        }
        PasswordParameterValue password = (PasswordParameterValue)parameterDefinition.getDefaultParameterValue();
        String jobDefaultPassword = password != null ? BuildWithParametersAction.getPasswordValue(password) : "";
        return new PasswordParameterValue(parameterValue.getName(), jobDefaultPassword);
    }

    static String getPasswordValue(PasswordParameterValue parameterValue) {
        Secret secret = parameterValue.getValue();
        return Secret.toString((Secret)secret);
    }

    private List<ParameterDefinition> getParameterDefinitions() {
        ParametersDefinitionProperty property = (ParametersDefinitionProperty)this.project.getProperty(ParametersDefinitionProperty.class);
        if (property != null && property.getParameterDefinitions() != null) {
            return property.getParameterDefinitions();
        }
        return new ArrayList<ParameterDefinition>();
    }
}

