/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.builduser.varsetter.impl;

import hudson.model.Cause;
import hudson.model.User;
import hudson.security.SecurityRealm;
import hudson.tasks.MailAddressResolver;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.builduser.utils.UsernameUtils;
import org.jenkinsci.plugins.builduser.varsetter.IUsernameSettable;
import org.jenkinsci.plugins.saml.SamlSecurityRealm;
import org.springframework.security.core.GrantedAuthority;

public class UserIdCauseDeterminant
implements IUsernameSettable<Cause.UserIdCause> {
    private static final Logger log = Logger.getLogger(UserIdCauseDeterminant.class.getName());

    @Override
    public boolean setJenkinsUserBuildVars(Cause.UserIdCause cause, Map<String, String> variables) {
        if (cause == null) {
            return false;
        }
        String username = cause.getUserName();
        UsernameUtils.setUsernameVars(username, variables);
        String trimmedUserId = StringUtils.trimToEmpty((String)cause.getUserId());
        String originalUserId = trimmedUserId.isEmpty() ? "anonymous" : trimmedUserId;
        String userid = this.mapUserId(originalUserId);
        variables.put("BUILD_USER_ID", userid);
        this.setUserGroups(originalUserId, variables);
        this.setUserEmail(originalUserId, variables);
        return true;
    }

    private String mapUserId(String userId) {
        try {
            SecurityRealm realm = Jenkins.get().getSecurityRealm();
            if (realm instanceof SamlSecurityRealm) {
                String conversion;
                SamlSecurityRealm samlSecurityRealm = (SamlSecurityRealm)realm;
                return switch (conversion = samlSecurityRealm.getUsernameCaseConversion()) {
                    case "lowercase" -> userId.toLowerCase();
                    case "uppercase" -> userId.toUpperCase();
                    default -> userId;
                };
            }
        }
        catch (NoClassDefFoundError e) {
            log.fine("It seems the saml plugin is not installed, skipping saml user name mapping.");
        }
        return userId;
    }

    private void setUserGroups(String userId, Map<String, String> variables) {
        try {
            Optional.ofNullable(User.getById((String)userId, (boolean)false)).map(User::impersonate2).map(authentication -> authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).filter(authority -> authority != null && !authority.isEmpty()).collect(Collectors.joining(","))).ifPresentOrElse(groups -> variables.put("BUILD_USER_GROUPS", (String)groups), () -> variables.put("BUILD_USER_GROUPS", ""));
        }
        catch (Exception err) {
            log.warning(String.format("Failed to get groups for user: %s error: %s ", userId, err));
        }
    }

    private void setUserEmail(String userId, Map<String, String> variables) {
        Optional.ofNullable(User.getById((String)userId, (boolean)false)).map(MailAddressResolver::resolve).ifPresent(email -> variables.put("BUILD_USER_EMAIL", (String)email));
    }

    @Override
    public Class<Cause.UserIdCause> getUsedCauseClass() {
        return Cause.UserIdCause.class;
    }
}

