/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.builduser;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.triggers.SCMTrigger;
import hudson.triggers.TimerTrigger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.branch.BranchEventCause;
import jenkins.branch.BranchIndexingCause;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildWrapper;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.builduser.varsetter.impl.BranchIndexingTriggerDeterminant;
import org.jenkinsci.plugins.builduser.varsetter.impl.RemoteCauseDeterminant;
import org.jenkinsci.plugins.builduser.varsetter.impl.SCMTriggerCauseDeterminant;
import org.jenkinsci.plugins.builduser.varsetter.impl.TimerTriggerCauseDeterminant;
import org.jenkinsci.plugins.builduser.varsetter.impl.UserCauseDeterminant;
import org.jenkinsci.plugins.builduser.varsetter.impl.UserIdCauseDeterminant;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class BuildUser
extends SimpleBuildWrapper {
    private static final Logger log = Logger.getLogger(BuildUser.class.getName());
    private static final String EXTENSION_DISPLAY_NAME = "Set jenkins user build variables";

    @DataBoundConstructor
    public BuildUser() {
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) {
        HashMap<String, String> variables = new HashMap<String, String>();
        BuildUser.makeUserBuildVariables(build, variables);
        for (Map.Entry entry : variables.entrySet()) {
            context.env((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Restricted(value={NoExternalUse.class})
    static void makeUserBuildVariables(@NonNull Run<?, ?> build, @NonNull Map<String, String> variables) {
        Run upstream;
        Job job;
        Cause.UserIdCause userIdCause = (Cause.UserIdCause)build.getCause(Cause.UserIdCause.class);
        if (new UserIdCauseDeterminant().setJenkinsUserBuildVars(userIdCause, variables)) {
            return;
        }
        Cause.UserCause userCause = (Cause.UserCause)build.getCause(Cause.UserCause.class);
        if (new UserCauseDeterminant().setJenkinsUserBuildVars(userCause, variables)) {
            return;
        }
        Cause.UpstreamCause upstreamCause = (Cause.UpstreamCause)build.getCause(Cause.UpstreamCause.class);
        if (upstreamCause != null && (job = (Job)Jenkins.get().getItemByFullName(upstreamCause.getUpstreamProject(), Job.class)) != null && (upstream = job.getBuildByNumber(upstreamCause.getUpstreamBuild())) != null) {
            BuildUser.makeUserBuildVariables(upstream, variables);
            return;
        }
        BuildUser.handleOtherCausesOrLogWarningIfUnhandled(build, variables);
    }

    private static void handleOtherCausesOrLogWarningIfUnhandled(@NonNull Run<?, ?> build, @NonNull Map<String, String> variables) {
        SCMTrigger.SCMTriggerCause scmTriggerCause = (SCMTrigger.SCMTriggerCause)build.getCause(SCMTrigger.SCMTriggerCause.class);
        if (new SCMTriggerCauseDeterminant().setJenkinsUserBuildVars(scmTriggerCause, variables)) {
            return;
        }
        TimerTrigger.TimerTriggerCause timerTriggerCause = (TimerTrigger.TimerTriggerCause)build.getCause(TimerTrigger.TimerTriggerCause.class);
        if (new TimerTriggerCauseDeterminant().setJenkinsUserBuildVars(timerTriggerCause, variables)) {
            return;
        }
        Cause.RemoteCause remoteTriggerCause = (Cause.RemoteCause)build.getCause(Cause.RemoteCause.class);
        if (new RemoteCauseDeterminant().setJenkinsUserBuildVars(remoteTriggerCause, variables)) {
            return;
        }
        try {
            BranchIndexingCause branchIndexingCause = (BranchIndexingCause)build.getCause(BranchIndexingCause.class);
            if (new BranchIndexingTriggerDeterminant().setJenkinsUserBuildVars(branchIndexingCause, variables)) {
                return;
            }
            BranchEventCause branchEventCause = (BranchEventCause)build.getCause(BranchEventCause.class);
            if (branchEventCause != null) {
                return;
            }
        }
        catch (NoClassDefFoundError e) {
            log.fine("It seems the branch-api plugin is not installed, skipping.");
        }
        log.warning(() -> "Unsupported cause type(s): " + Arrays.toString(build.getCauses().toArray()));
    }

    @Extension
    @Symbol(value={"withBuildUser"})
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        @NonNull
        public String getDisplayName() {
            return BuildUser.EXTENSION_DISPLAY_NAME;
        }
    }
}

