/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.build_token_root;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.BuildAuthorizationToken;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.model.UnprotectedRootAction;
import hudson.model.queue.ScheduleResult;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.csrf.CrumbExclusion;
import hudson.triggers.SCMTrigger;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.triggers.SCMTriggerItem;
import jenkins.util.TimeDuration;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

@Extension
public class BuildRootAction
implements UnprotectedRootAction {
    private static final Logger LOGGER = Logger.getLogger(BuildRootAction.class.getName());
    public static final String URLNAME = "buildByToken";

    public String getUrlName() {
        return URLNAME;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public void doBuild(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter String job, @QueryParameter TimeDuration delay) throws IOException, ServletException {
        ParametersDefinitionProperty pp;
        LOGGER.log(Level.FINE, "build on {0}", job);
        ParameterizedJobMixIn.ParameterizedJob<?, ?> p = this.project(job, req, rsp);
        if (delay == null) {
            delay = new TimeDuration((long)p.getQuietPeriod());
        }
        if ((pp = (ParametersDefinitionProperty)((Job)p).getProperty(ParametersDefinitionProperty.class)) != null) {
            LOGGER.fine("wrong kind");
            throw HttpResponses.error((int)400, (String)"Use /buildByToken/buildWithParameters for this job since it takes parameters");
        }
        ScheduleResult result = Jenkins.get().getQueue().schedule2(p, delay.getTimeInSeconds(), new Action[]{this.getBuildCause(req)});
        this.handleScheduleResult(result, job, req, rsp);
    }

    public void doBuildWithParameters(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter String job, @QueryParameter TimeDuration delay) throws IOException, ServletException {
        ParametersDefinitionProperty pp;
        LOGGER.log(Level.FINE, "buildWithParameters on {0}", job);
        ParameterizedJobMixIn.ParameterizedJob<?, ?> p = this.project(job, req, rsp);
        if (delay == null) {
            delay = new TimeDuration((long)p.getQuietPeriod());
        }
        if ((pp = (ParametersDefinitionProperty)((Job)p).getProperty(ParametersDefinitionProperty.class)) == null) {
            LOGGER.fine("wrong kind");
            throw HttpResponses.error((int)400, (String)"Use /buildByToken/build for this job since it takes no parameters");
        }
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
        for (ParameterDefinition d : pp.getParameterDefinitions()) {
            ParameterValue value = d.createValue(req);
            if (value == null) continue;
            values.add(value);
        }
        ScheduleResult result = Jenkins.get().getQueue().schedule2(p, delay.getTimeInSeconds(), new Action[]{new ParametersAction(values), this.getBuildCause(req)});
        this.handleScheduleResult(result, job, req, rsp);
    }

    public void doPolling(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter String job) throws IOException, ServletException {
        LOGGER.log(Level.FINE, "polling on {0}", job);
        ParameterizedJobMixIn.ParameterizedJob<?, ?> p = this.project(job, req, rsp);
        SCMTriggerItem scmp = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem(p);
        if (scmp == null) {
            LOGGER.log(Level.FINE, "{0} is not a SCMTriggerItem", p);
            throw HttpResponses.error((int)400, (Throwable)new IOException(job + " is not a SCMTriggerItem"));
        }
        SCMTrigger trigger = scmp.getSCMTrigger();
        if (trigger == null) {
            LOGGER.log(Level.FINE, "{0} is not configured to poll", p);
            throw HttpResponses.error((int)400, (Throwable)new IOException(job + " is not configured to poll"));
        }
        trigger.run();
        this.ok(rsp);
    }

    private ParameterizedJobMixIn.ParameterizedJob<?, ?> project(String job, StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, HttpResponses.HttpResponseException {
        Job j;
        try (ACLContext c = ACL.as((Authentication)ACL.SYSTEM);){
            j = (Job)Jenkins.get().getItemByFullName(job, Job.class);
        }
        if (j == null) {
            LOGGER.log(Level.FINE, "no such job {0}", job);
            throw HttpResponses.notFound();
        }
        if (!(j instanceof ParameterizedJobMixIn.ParameterizedJob)) {
            LOGGER.log(Level.FINE, "{0} is not a ParameterizedJob", j);
            throw HttpResponses.notFound();
        }
        ParameterizedJobMixIn.ParameterizedJob p = (ParameterizedJobMixIn.ParameterizedJob)j;
        BuildAuthorizationToken authToken = p.getAuthToken();
        if (authToken == null || authToken.getToken() == null) {
            LOGGER.log(Level.FINE, "no authToken on {0}", job);
            throw HttpResponses.notFound();
        }
        try {
            BuildAuthorizationToken.checkPermission((Job)((Job)p), (BuildAuthorizationToken)authToken, (StaplerRequest2)req, (StaplerResponse2)rsp);
        }
        catch (RuntimeException x) {
            LOGGER.log(Level.FINE, "on {0} was denied: {1}", new Object[]{job, x.getMessage()});
            throw x;
        }
        if (!j.isBuildable()) {
            LOGGER.log(Level.FINE, "{0} is not buildable", job);
            throw HttpResponses.error((int)400, (Throwable)new IOException(job + " is not buildable"));
        }
        LOGGER.log(Level.FINE, "found {0}", p);
        return p;
    }

    private CauseAction getBuildCause(StaplerRequest2 req) {
        return new CauseAction((Cause)new Cause.RemoteCause(req.getRemoteAddr(), req.getParameter("cause")));
    }

    private void ok(StaplerResponse2 rsp) throws IOException {
        rsp.setContentType("text/html");
        try (PrintWriter w = rsp.getWriter();){
            w.write("Scheduled.\n");
        }
    }

    private void handleScheduleResult(ScheduleResult result, String job, StaplerRequest2 req, StaplerResponse2 rsp) throws HttpResponses.HttpResponseException, IOException {
        if (result.isAccepted()) {
            Queue.Item item = result.getItem();
            assert (item != null);
            String itemUrl = req.getContextPath() + "/" + item.getUrl();
            if (result.isCreated()) {
                rsp.setStatus(201);
                rsp.addHeader("Location", itemUrl);
            } else {
                rsp.sendRedirect(303, itemUrl);
            }
        } else {
            LOGGER.log(Level.FINE, "Jenkins refused to queue job \u201c{0}\u201d", job);
            throw HttpResponses.forbidden();
        }
    }

    @Extension
    public static class BuildRootActionCrumbExclusion
    extends CrumbExclusion {
        public boolean process(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
            String pathInfo = req.getPathInfo();
            if (pathInfo != null && pathInfo.startsWith(this.getExclusionPath())) {
                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
                return true;
            }
            return false;
        }

        public String getExclusionPath() {
            return "/buildByToken/";
        }
    }
}

