/*
 * Decompiled with CFR 0.152.
 */
package com.orctom.jenkins.plugin.buildtimestamp;

import com.orctom.jenkins.plugin.buildtimestamp.BuildTimestampExtraProperty;
import com.orctom.jenkins.plugin.buildtimestamp.ShiftExpressionHelper;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public class BuildTimestampWrapper
extends BuildWrapper {

    @Extension
    @Symbol(value={"buildTimestamp"})
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        private boolean enableBuildTimestamp = true;
        private String timezone = TimeZone.getDefault().getID();
        private String pattern = "yyyy-MM-dd HH:mm:ss z";
        private Set<BuildTimestampExtraProperty> extraProperties = new HashSet<BuildTimestampExtraProperty>();

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(AbstractProject<?, ?> abstractProject) {
            return false;
        }

        public String getDisplayName() {
            return "";
        }

        public boolean configure(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            this.enableBuildTimestamp = false;
            this.timezone = null;
            this.pattern = null;
            JSONObject data = formData.getJSONObject("enableBuildTimestamp");
            if (this.isNullJSONObject(data)) {
                this.enableBuildTimestamp = false;
            } else {
                this.enableBuildTimestamp = true;
                this.timezone = data.getString("timezone");
                this.pattern = data.getString("pattern");
                Object extraPropertyValues = data.get("extraProperties");
                this.extraProperties = null != extraPropertyValues ? this.extractExtraProperties(extraPropertyValues) : new HashSet<BuildTimestampExtraProperty>();
            }
            this.save();
            return super.configure(req, formData);
        }

        private boolean isNullJSONObject(JSONObject data) {
            return null == data || data.isNullObject() || data.isEmpty();
        }

        private Set<BuildTimestampExtraProperty> extractExtraProperties(Object extraPropertyValues) {
            HashSet<BuildTimestampExtraProperty> properties = new HashSet<BuildTimestampExtraProperty>();
            if (extraPropertyValues instanceof JSONArray) {
                JSONArray array = (JSONArray)extraPropertyValues;
                for (Object item : array) {
                    this.addProperty(properties, item);
                }
            } else if (extraPropertyValues instanceof JSONObject) {
                this.addProperty(properties, extraPropertyValues);
            }
            return properties;
        }

        private void addProperty(Set<BuildTimestampExtraProperty> properties, Object obj) {
            JSONObject data = (JSONObject)obj;
            String key = data.getString("key");
            String value = data.getString("value");
            String shiftExpression = data.getString("shiftExpression");
            if (this.isVariableNameValid(key) && this.isPatternValid(value) && ShiftExpressionHelper.isShiftExpressionValid(shiftExpression)) {
                properties.add(new BuildTimestampExtraProperty(key, value, shiftExpression));
            }
        }

        private boolean isVariableNameValid(String name) {
            return null != name && 0 != name.trim().length() && !name.matches(".*\\W.*");
        }

        private boolean isPatternValid(String pattern) {
            if (null == pattern || 0 == pattern.trim().length()) {
                return false;
            }
            try {
                new SimpleDateFormat(pattern);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        private String getConfiguredTimezone(String timezoneParam) {
            if (null == timezoneParam || 0 == timezoneParam.trim().length()) {
                return TimeZone.getDefault().getID();
            }
            return TimeZone.getTimeZone(timezoneParam).getID();
        }

        public FormValidation doCheckPattern(@QueryParameter(value="pattern") String patternParam, @QueryParameter(value="timezone") String timezoneParam) {
            String configuredTimezone = this.getConfiguredTimezone(timezoneParam);
            String patternStr = "yyyy-MM-dd HH:mm:ss z";
            if (null != patternParam && 0 != patternParam.trim().length()) {
                patternStr = patternParam.trim();
            }
            try {
                SimpleDateFormat df = new SimpleDateFormat(patternStr);
                df.setTimeZone(TimeZone.getTimeZone(configuredTimezone));
                return FormValidation.ok((String)"Using timezone: %s; Sample timestamp: %s", (Object[])new Object[]{configuredTimezone, df.format(new Date())});
            }
            catch (IllegalArgumentException e) {
                return FormValidation.error((String)"Invalid pattern");
            }
        }

        public FormValidation doCheckKey(@QueryParameter String value) {
            if (this.isVariableNameValid(value)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Invalid variable name");
        }

        public FormValidation doCheckValue(@QueryParameter String value) {
            if (this.isPatternValid(value)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Invalid pattern");
        }

        public FormValidation doCheckShiftExpression(@QueryParameter String value) {
            if (ShiftExpressionHelper.isShiftExpressionValid(value)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Invalid time shift expression");
        }

        public ComboBoxModel doFillTimezoneItems() {
            ComboBoxModel items = new ComboBoxModel();
            Collections.addAll(items, TimeZone.getAvailableIDs());
            return items;
        }

        public boolean isEnableBuildTimestamp() {
            return this.enableBuildTimestamp;
        }

        @DataBoundSetter
        public void setEnableBuildTimestamp(boolean enableBuildTimestamp) {
            this.enableBuildTimestamp = enableBuildTimestamp;
        }

        public String getPattern() {
            return this.pattern;
        }

        @DataBoundSetter
        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public String getTimezone() {
            return this.timezone;
        }

        @DataBoundSetter
        public void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public Set<BuildTimestampExtraProperty> getExtraProperties() {
            return this.extraProperties;
        }

        @DataBoundSetter
        public void setExtraProperties(Set<BuildTimestampExtraProperty> extraProperties) {
            this.extraProperties = extraProperties;
        }
    }
}

