/*
 * Decompiled with CFR 0.152.
 */
package com.orctom.jenkins.plugin.buildtimestamp;

import com.orctom.jenkins.plugin.buildtimestamp.BuildTimestampExtraProperty;
import com.orctom.jenkins.plugin.buildtimestamp.BuildTimestampWrapper;
import com.orctom.jenkins.plugin.buildtimestamp.ShiftExpressionHelper;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.EnvironmentContributor;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import jenkins.model.Jenkins;

@Extension
public class BuildTimestampEnvironmentContributor
extends EnvironmentContributor {
    public void buildEnvironmentFor(Run run, EnvVars envVars, TaskListener listener) throws IOException, InterruptedException {
        if (null == envVars.get((Object)"BUILD_TIMESTAMP")) {
            try {
                Map<String, String> timestampProperties = this.buildTimestamp(run.getTimestamp());
                envVars.putAll(timestampProperties);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Map<String, String> buildTimestamp(Calendar timestamp) {
        HashMap<String, String> timestampProperties = new HashMap<String, String>();
        BuildTimestampWrapper.DescriptorImpl descriptor = this.getDescriptorImpl();
        if (descriptor.isEnableBuildTimestamp()) {
            TimeZone timeZone = TimeZone.getTimeZone(descriptor.getTimezone());
            String pattern = descriptor.getPattern();
            this.setTimestamp(timestampProperties, "BUILD_TIMESTAMP", this.format(timestamp, timeZone, pattern, ""));
            Set<BuildTimestampExtraProperty> extraProperties = descriptor.getExtraProperties();
            for (BuildTimestampExtraProperty property : extraProperties) {
                this.setTimestamp(timestampProperties, property.getKey(), this.format(timestamp, timeZone, property.getValue(), property.getShiftExpression()));
            }
        }
        return timestampProperties;
    }

    private void setTimestamp(Map<String, String> timestampProperties, String key, String value) {
        timestampProperties.put(key, value);
        System.setProperty(key, value);
    }

    private String format(Calendar timestamp, TimeZone timeZone, String pattern, String shiftExpression) {
        Calendar timestamp2 = ShiftExpressionHelper.doShift(timestamp, shiftExpression);
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        format.setTimeZone(timeZone);
        return format.format(timestamp2.getTime());
    }

    public BuildTimestampWrapper.DescriptorImpl getDescriptorImpl() {
        return (BuildTimestampWrapper.DescriptorImpl)Jenkins.getInstance().getDescriptorOrDie(BuildTimestampWrapper.class);
    }
}

