// CHECKSTYLE:OFF

package hudson.plugins.build_timeout.impl;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code NoActivityTimeOutStrategy.DisplayName}: {@code No

     * Activity}.
     * 
     * @return
     *     {@code No Activity}
     */
    public static String NoActivityTimeOutStrategy_DisplayName() {
        return holder.format("NoActivityTimeOutStrategy.DisplayName");
    }

    /**
     * Key {@code NoActivityTimeOutStrategy.DisplayName}: {@code No

     * Activity}.
     * 
     * @return
     *     {@code No Activity}
     */
    public static Localizable _NoActivityTimeOutStrategy_DisplayName() {
        return new Localizable(holder, "NoActivityTimeOutStrategy.DisplayName");
    }

    /**
     * Key {@code DeadlineTimeOutStrategy.NextDeadline}: {@code Build allowed

     * to run until deadline: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Build allowed to run until deadline: {0}}
     */
    public static String DeadlineTimeOutStrategy_NextDeadline(Object arg0) {
        return holder.format("DeadlineTimeOutStrategy.NextDeadline", arg0);
    }

    /**
     * Key {@code DeadlineTimeOutStrategy.NextDeadline}: {@code Build allowed

     * to run until deadline: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Build allowed to run until deadline: {0}}
     */
    public static Localizable _DeadlineTimeOutStrategy_NextDeadline(Object arg0) {
        return new Localizable(holder, "DeadlineTimeOutStrategy.NextDeadline", arg0);
    }

    /**
     * Key {@code AbsoluteTimeOutStrategy.DisplayName}: {@code Absolute}.
     * 
     * @return
     *     {@code Absolute}
     */
    public static String AbsoluteTimeOutStrategy_DisplayName() {
        return holder.format("AbsoluteTimeOutStrategy.DisplayName");
    }

    /**
     * Key {@code AbsoluteTimeOutStrategy.DisplayName}: {@code Absolute}.
     * 
     * @return
     *     {@code Absolute}
     */
    public static Localizable _AbsoluteTimeOutStrategy_DisplayName() {
        return new Localizable(holder, "AbsoluteTimeOutStrategy.DisplayName");
    }

    /**
     * Key {@code DeadlineTimeOutStrategy.InvalidDeadlineFormat}: {@code

     * Specified deadline time ''{0}'' does not match 24-hour time format

     * (HH:MM or HH:MM:SS)}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Specified deadline time ''{0}'' does not match 24-hour time

     *     format (HH:MM or HH:MM:SS)}
     */
    public static String DeadlineTimeOutStrategy_InvalidDeadlineFormat(Object arg0) {
        return holder.format("DeadlineTimeOutStrategy.InvalidDeadlineFormat", arg0);
    }

    /**
     * Key {@code DeadlineTimeOutStrategy.InvalidDeadlineFormat}: {@code

     * Specified deadline time ''{0}'' does not match 24-hour time format

     * (HH:MM or HH:MM:SS)}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Specified deadline time ''{0}'' does not match 24-hour time

     *     format (HH:MM or HH:MM:SS)}
     */
    public static Localizable _DeadlineTimeOutStrategy_InvalidDeadlineFormat(Object arg0) {
        return new Localizable(holder, "DeadlineTimeOutStrategy.InvalidDeadlineFormat", arg0);
    }

    /**
     * Key {@code DeadlineTimeOutStrategy.DeadlineFormatWithMacros}: {@code

     * Deadline specified as a variable reference. When evaluated it must

     * match a 24-hour time format (HH:MM or HH:MM:SS)}.
     * 
     * @return
     *     {@code Deadline specified as a variable reference. When evaluated it

     *     must match a 24-hour time format (HH:MM or HH:MM:SS)}
     */
    public static String DeadlineTimeOutStrategy_DeadlineFormatWithMacros() {
        return holder.format("DeadlineTimeOutStrategy.DeadlineFormatWithMacros");
    }

    /**
     * Key {@code DeadlineTimeOutStrategy.DeadlineFormatWithMacros}: {@code

     * Deadline specified as a variable reference. When evaluated it must

     * match a 24-hour time format (HH:MM or HH:MM:SS)}.
     * 
     * @return
     *     {@code Deadline specified as a variable reference. When evaluated it

     *     must match a 24-hour time format (HH:MM or HH:MM:SS)}
     */
    public static Localizable _DeadlineTimeOutStrategy_DeadlineFormatWithMacros() {
        return new Localizable(holder, "DeadlineTimeOutStrategy.DeadlineFormatWithMacros");
    }

    /**
     * Key {@code DeadlineTimeOutStrategy.ImmediatelyTerminate}: {@code Build

     * timestamp inside deadline tolerance period ({0} + {1} min).

     * Terminating immediately.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Build timestamp inside deadline tolerance period ({0} + {1}

     *     min). Terminating immediately.}
     */
    public static String DeadlineTimeOutStrategy_ImmediatelyTerminate(Object arg0, Object arg1) {
        return holder.format("DeadlineTimeOutStrategy.ImmediatelyTerminate", arg0, arg1);
    }

    /**
     * Key {@code DeadlineTimeOutStrategy.ImmediatelyTerminate}: {@code Build

     * timestamp inside deadline tolerance period ({0} + {1} min).

     * Terminating immediately.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Build timestamp inside deadline tolerance period ({0} + {1}

     *     min). Terminating immediately.}
     */
    public static Localizable _DeadlineTimeOutStrategy_ImmediatelyTerminate(Object arg0, Object arg1) {
        return new Localizable(holder, "DeadlineTimeOutStrategy.ImmediatelyTerminate", arg0, arg1);
    }

    /**
     * Key {@code DeadlineTimeOutStrategy.DisplayName}: {@code Deadline}.
     * 
     * @return
     *     {@code Deadline}
     */
    public static String DeadlineTimeOutStrategy_DisplayName() {
        return holder.format("DeadlineTimeOutStrategy.DisplayName");
    }

    /**
     * Key {@code DeadlineTimeOutStrategy.DisplayName}: {@code Deadline}.
     * 
     * @return
     *     {@code Deadline}
     */
    public static Localizable _DeadlineTimeOutStrategy_DisplayName() {
        return new Localizable(holder, "DeadlineTimeOutStrategy.DisplayName");
    }

    /**
     * Key {@code ElasticTimeOutStrategy.DisplayName}: {@code Elastic}.
     * 
     * @return
     *     {@code Elastic}
     */
    public static String ElasticTimeOutStrategy_DisplayName() {
        return holder.format("ElasticTimeOutStrategy.DisplayName");
    }

    /**
     * Key {@code ElasticTimeOutStrategy.DisplayName}: {@code Elastic}.
     * 
     * @return
     *     {@code Elastic}
     */
    public static Localizable _ElasticTimeOutStrategy_DisplayName() {
        return new Localizable(holder, "ElasticTimeOutStrategy.DisplayName");
    }

    /**
     * Key {@code LikelyStuckTimeOutStrategy.DisplayName}: {@code Likely

     * stuck}.
     * 
     * @return
     *     {@code Likely stuck}
     */
    public static String LikelyStuckTimeOutStrategy_DisplayName() {
        return holder.format("LikelyStuckTimeOutStrategy.DisplayName");
    }

    /**
     * Key {@code LikelyStuckTimeOutStrategy.DisplayName}: {@code Likely

     * stuck}.
     * 
     * @return
     *     {@code Likely stuck}
     */
    public static Localizable _LikelyStuckTimeOutStrategy_DisplayName() {
        return new Localizable(holder, "LikelyStuckTimeOutStrategy.DisplayName");
    }

}
