// CHECKSTYLE:OFF

package hudson.plugins.build_timeout;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code BuildStepWithTimeout.DisplayName}: {@code Run with

     * timeout}.
     * 
     * @return
     *     {@code Run with timeout}
     */
    public static String BuildStepWithTimeout_DisplayName() {
        return holder.format("BuildStepWithTimeout.DisplayName");
    }

    /**
     * Key {@code BuildStepWithTimeout.DisplayName}: {@code Run with

     * timeout}.
     * 
     * @return
     *     {@code Run with timeout}
     */
    public static Localizable _BuildStepWithTimeout_DisplayName() {
        return new Localizable(holder, "BuildStepWithTimeout.DisplayName");
    }

    /**
     * Key {@code Descriptor.DisplayName}: {@code Terminate a build if it''s

     * stuck}.
     * 
     * @return
     *     {@code Terminate a build if it''s stuck}
     */
    public static String Descriptor_DisplayName() {
        return holder.format("Descriptor.DisplayName");
    }

    /**
     * Key {@code Descriptor.DisplayName}: {@code Terminate a build if it''s

     * stuck}.
     * 
     * @return
     *     {@code Terminate a build if it''s stuck}
     */
    public static Localizable _Descriptor_DisplayName() {
        return new Localizable(holder, "Descriptor.DisplayName");
    }

    /**
     * Key {@code Timeout.Message}: {@code Build timed out (after {0}

     * minutes). Marking the build as {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Build timed out (after {0} minutes). Marking the build as {1}.}
     */
    public static String Timeout_Message(Object arg0, Object arg1) {
        return holder.format("Timeout.Message", arg0, arg1);
    }

    /**
     * Key {@code Timeout.Message}: {@code Build timed out (after {0}

     * minutes). Marking the build as {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Build timed out (after {0} minutes). Marking the build as {1}.}
     */
    public static Localizable _Timeout_Message(Object arg0, Object arg1) {
        return new Localizable(holder, "Timeout.Message", arg0, arg1);
    }

    /**
     * Key {@code Timeout.Aborted}: {@code aborted}.
     * 
     * @return
     *     {@code aborted}
     */
    public static String Timeout_Aborted() {
        return holder.format("Timeout.Aborted");
    }

    /**
     * Key {@code Timeout.Aborted}: {@code aborted}.
     * 
     * @return
     *     {@code aborted}
     */
    public static Localizable _Timeout_Aborted() {
        return new Localizable(holder, "Timeout.Aborted");
    }

    /**
     * Key {@code Timeout.Failed}: {@code failed}.
     * 
     * @return
     *     {@code failed}
     */
    public static String Timeout_Failed() {
        return holder.format("Timeout.Failed");
    }

    /**
     * Key {@code Timeout.Failed}: {@code failed}.
     * 
     * @return
     *     {@code failed}
     */
    public static Localizable _Timeout_Failed() {
        return new Localizable(holder, "Timeout.Failed");
    }

}
