/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.build_timeout.operations;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.plugins.build_timeout.BuildTimeOutOperation;
import hudson.plugins.build_timeout.BuildTimeOutOperationDescriptor;
import hudson.plugins.build_timeout.operations.Messages;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import org.kohsuke.stapler.DataBoundConstructor;

public class WriteDescriptionOperation
extends BuildTimeOutOperation {
    private final String description;

    public String getDescription() {
        return this.description;
    }

    @DataBoundConstructor
    public WriteDescriptionOperation(String description) {
        this.description = description;
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, BuildListener listener, long effectiveTimeout) {
        long effectiveTimeoutMinutes = TimeUnit.MINUTES.convert(effectiveTimeout, TimeUnit.MILLISECONDS);
        String msg = this.getDescription();
        try {
            msg = build.getEnvironment((TaskListener)listener).expand(msg);
        }
        catch (IOException | InterruptedException e) {
            listener.getLogger().println(String.format("failed to expand string: %s", msg));
            e.printStackTrace(listener.getLogger());
        }
        msg = MessageFormat.format(msg, effectiveTimeoutMinutes);
        try {
            build.setDescription(msg);
        }
        catch (IOException e) {
            listener.getLogger().println("failed to write to the build description!");
            e.printStackTrace(listener.getLogger());
        }
        return true;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildTimeOutOperationDescriptor {
        public String getDisplayName() {
            return Messages.WriteDescriptionOperation_DisplayName();
        }
    }
}

