/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.build_timeout.operations;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Executor;
import hudson.model.Result;
import hudson.plugins.build_timeout.BuildTimeOutOperation;
import hudson.plugins.build_timeout.BuildTimeOutOperationDescriptor;
import hudson.plugins.build_timeout.Messages;
import java.util.concurrent.TimeUnit;
import org.kohsuke.stapler.DataBoundConstructor;

public class AbortOperation
extends BuildTimeOutOperation {
    @DataBoundConstructor
    public AbortOperation() {
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, BuildListener listener, long effectiveTimeout) {
        long effectiveTimeoutMinutes = TimeUnit.MINUTES.convert(effectiveTimeout, TimeUnit.MILLISECONDS);
        listener.getLogger().println(Messages.Timeout_Message(effectiveTimeoutMinutes, Messages.Timeout_Aborted()));
        Executor e = build.getExecutor();
        if (e != null) {
            e.interrupt(Result.ABORTED);
        }
        return true;
    }

    @Extension(ordinal=100.0)
    public static class DescriptorImpl
    extends BuildTimeOutOperationDescriptor {
        public String getDisplayName() {
            return hudson.plugins.build_timeout.operations.Messages.AbortOperation_DisplayName();
        }
    }
}

