/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.build_timeout;

import hudson.model.Describable;
import hudson.model.Descriptor;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest2;

public class BuildTimeOutUtility {
    public static <T> T bindJSONWithDescriptor(StaplerRequest2 req, JSONObject formData, String fieldName, Class<T> expectedClazz) throws Descriptor.FormException {
        if ((formData = formData.getJSONObject(fieldName)) == null || formData.isNullObject()) {
            return null;
        }
        String clazzName = formData.optString("$class", null);
        if (clazzName == null) {
            clazzName = formData.optString("stapler-class", null);
        }
        if (clazzName == null) {
            throw new Descriptor.FormException("No $class or stapler-class is specified", fieldName);
        }
        try {
            Class<?> clazz = Jenkins.getActiveInstance().getPluginManager().uberClassLoader.loadClass(clazzName);
            Descriptor d = Jenkins.getActiveInstance().getDescriptorOrDie(clazz);
            Describable ret = d.newInstance(req, formData);
            return (T)ret;
        }
        catch (ClassNotFoundException e) {
            throw new Descriptor.FormException(String.format("Failed to instantiate: class not found %s", clazzName), (Throwable)e, fieldName);
        }
        catch (ClassCastException e) {
            throw new Descriptor.FormException(String.format("Failed to instantiate: instantiated as %s but expected %s", clazzName, expectedClazz.getName()), (Throwable)e, fieldName);
        }
    }
}

