/*
 * Decompiled with CFR 0.152.
 */
package au.com.centrumsystems.hudson.plugin.util;

import au.com.centrumsystems.hudson.plugin.buildpipeline.trigger.BuildPipelineTrigger;
import hudson.model.AbstractProject;
import hudson.model.DependencyGraph;
import hudson.model.Hudson;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;

public final class ProjectUtil {
    public static List<AbstractProject<?, ?>> getDownstreamProjects(AbstractProject<?, ?> currentProject) {
        DependencyGraph myDependencyGraph = Hudson.getInstance().getDependencyGraph();
        ArrayList downstreamProjectsList = new ArrayList();
        for (AbstractProject proj : myDependencyGraph.getDownstream(currentProject)) {
            downstreamProjectsList.add(proj);
        }
        return downstreamProjectsList;
    }

    public static boolean hasDownstreamProjects(AbstractProject<?, ?> currentProject) {
        return ProjectUtil.getDownstreamProjects(currentProject).size() > 0;
    }

    public static boolean isManualTrigger(AbstractProject<?, ?> upstreamProject, AbstractProject<?, ?> downstreamProject) {
        boolean manualTrigger = false;
        if (upstreamProject != null && downstreamProject != null) {
            DescribableList upstreamPublishersLists = upstreamProject.getPublishersList();
            block0: for (Publisher upstreamPub : upstreamPublishersLists) {
                String[] downstreamProjs;
                if (!(upstreamPub instanceof BuildPipelineTrigger)) continue;
                String manualDownstreamProjects = ((BuildPipelineTrigger)upstreamPub).getDownstreamProjectNames();
                for (String nextProj : downstreamProjs = manualDownstreamProjects.split(",")) {
                    if (Jenkins.getInstance().getItem(nextProj.trim(), upstreamProject) != downstreamProject) continue;
                    manualTrigger = true;
                    continue block0;
                }
            }
        }
        return manualTrigger;
    }

    public static ParametersAction getProjectParametersAction(AbstractProject<?, ?> project) {
        if (project != null) {
            ParametersDefinitionProperty property = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
            if (property == null) {
                return null;
            }
            ArrayList<ParameterValue> parameters = new ArrayList<ParameterValue>();
            for (ParameterDefinition pd : property.getParameterDefinitions()) {
                ParameterValue param = pd.getDefaultParameterValue();
                if (param == null) continue;
                parameters.add(param);
            }
            return new ParametersAction(parameters);
        }
        return null;
    }
}

