/*
 * Decompiled with CFR 0.152.
 */
package au.com.centrumsystems.hudson.plugin.buildpipeline;

import au.com.centrumsystems.hudson.plugin.buildpipeline.Strings;
import au.com.centrumsystems.hudson.plugin.util.BuildUtil;
import au.com.centrumsystems.hudson.plugin.util.HudsonResult;
import au.com.centrumsystems.hudson.plugin.util.ProjectUtil;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Result;
import hudson.plugins.parameterizedtrigger.BlockableBuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.SubProjectsAction;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

public class PipelineBuild {
    private AbstractBuild<?, ?> currentBuild;
    private AbstractProject<?, ?> project;
    private AbstractBuild<?, ?> upstreamBuild;
    private String upstreamBuildResult;
    private String currentBuildResult;
    private static final Logger LOGGER = Logger.getLogger(PipelineBuild.class.getName());

    public PipelineBuild() {
    }

    public PipelineBuild(AbstractBuild<?, ?> build, AbstractProject<?, ?> project, AbstractBuild<?, ?> previousBuild) {
        this.currentBuild = build;
        this.project = project;
        this.upstreamBuild = previousBuild;
        this.currentBuildResult = "";
        this.upstreamBuildResult = "";
    }

    public PipelineBuild(AbstractBuild<?, ?> build) {
        this(build, build.getProject(), build.getPreviousBuild());
    }

    public PipelineBuild(FreeStyleProject project) {
        this(null, (AbstractProject<?, ?>)project, null);
    }

    public AbstractBuild<?, ?> getCurrentBuild() {
        return this.currentBuild;
    }

    public void setCurrentBuild(AbstractBuild<?, ?> currentBuild) {
        this.currentBuild = currentBuild;
    }

    public AbstractBuild<?, ?> getUpstreamBuild() {
        return this.upstreamBuild;
    }

    public void setUpstreamBuild(AbstractBuild<?, ?> upstreamBuild) {
        this.upstreamBuild = upstreamBuild;
    }

    public void setProject(AbstractProject<?, ?> currentProject) {
        this.project = currentProject;
    }

    public AbstractProject<?, ?> getProject() {
        AbstractProject currentProject = this.project == null && this.currentBuild != null ? this.currentBuild.getProject() : this.project;
        return currentProject;
    }

    public String getCurrentBuildNumber() {
        if (this.currentBuild != null) {
            return Integer.toString(this.currentBuild.getNumber());
        }
        return "";
    }

    public List<PipelineBuild> getDownstreamPipeline() {
        ArrayList<PipelineBuild> pbList = new ArrayList<PipelineBuild>();
        AbstractProject<?, ?> currentProject = this.getProject();
        List<AbstractProject<?, ?>> downstreamProjects = ProjectUtil.getDownstreamProjects(currentProject);
        for (AbstractProject<?, ?> proj : downstreamProjects) {
            AbstractBuild<?, ?> returnedBuild = null;
            if (this.currentBuild != null) {
                returnedBuild = BuildUtil.getDownstreamBuild(proj, this.currentBuild);
            }
            PipelineBuild newPB = new PipelineBuild(returnedBuild, proj, this.currentBuild);
            pbList.add(newPB);
        }
        if (Hudson.getInstance().getPlugin("parameterized-trigger") != null) {
            for (SubProjectsAction action : Util.filter((List)currentProject.getActions(), SubProjectsAction.class)) {
                for (BlockableBuildTriggerConfig config : action.getConfigs()) {
                    for (AbstractProject dependency : config.getProjectList(currentProject.getParent(), null)) {
                        PipelineBuild candidate;
                        AbstractBuild<?, ?> returnedBuild = null;
                        if (this.currentBuild != null) {
                            returnedBuild = BuildUtil.getDownstreamBuild(dependency, this.currentBuild);
                        }
                        if (pbList.contains(candidate = new PipelineBuild(returnedBuild, dependency, this.currentBuild))) continue;
                        pbList.add(candidate);
                    }
                }
            }
        }
        return pbList;
    }

    public String getBuildResultURL() {
        return this.currentBuild != null ? this.currentBuild.getUrl() : "";
    }

    public String getProjectURL() {
        return this.project != null ? this.project.getUrl() : "";
    }

    public String getCurrentBuildResult() {
        this.currentBuildResult = this.getBuildResult(this.currentBuild);
        return this.currentBuildResult;
    }

    public String getUpstreamBuildResult() {
        if (this.upstreamBuildResult.length() == 0) {
            this.upstreamBuildResult = this.getBuildResult(this.upstreamBuild);
        }
        return this.upstreamBuildResult;
    }

    private String getBuildResult(AbstractBuild<?, ?> build) {
        String buildResult;
        if (build != null) {
            if (build.isBuilding()) {
                buildResult = HudsonResult.BUILDING.toString();
            } else {
                Result result = build.getResult();
                if (result == null) {
                    throw new IllegalStateException("Build with a null result after build has finished");
                }
                buildResult = HudsonResult.values()[result.ordinal].toString();
            }
        } else {
            buildResult = this.getPendingStatus();
        }
        return buildResult;
    }

    private String getPendingStatus() {
        String pendingStatus = HudsonResult.PENDING.toString();
        PipelineBuild upstreamPB = this.getUpstreamPipelineBuild();
        if (upstreamPB != null && this.getUpstreamBuild() != null && (this.getUpstreamBuildResult().equals(HudsonResult.SUCCESS.toString()) || this.getUpstreamBuildResult().equals(HudsonResult.UNSTABLE.toString())) && ProjectUtil.isManualTrigger(this.upstreamBuild.getProject(), this.project)) {
            pendingStatus = HudsonResult.MANUAL.toString();
        }
        return pendingStatus;
    }

    public PipelineBuild getUpstreamPipelineBuild() {
        List upstreamProjects = this.getProject().getUpstreamProjects();
        AbstractProject previousProject = null;
        PipelineBuild previousPB = new PipelineBuild();
        String upstreamBuildName = this.upstreamBuild != null ? this.upstreamBuild.getProject().getName() : "";
        if (upstreamProjects.size() > 0) {
            for (AbstractProject upstreamProject : upstreamProjects) {
                if (!upstreamProject.getName().equals(upstreamBuildName)) continue;
                previousProject = upstreamProject;
                break;
            }
            if (previousProject == null) {
                previousProject = (AbstractProject)upstreamProjects.get(0);
            }
            previousPB.setCurrentBuild(this.getUpstreamBuild());
            previousPB.setProject(previousProject);
        }
        return previousPB;
    }

    public String getBuildDuration() {
        if (this.currentBuild != null) {
            return this.currentBuild.getDurationString();
        }
        return "";
    }

    public String toString() {
        return "Project: " + this.getProject().getName() + " : Build: " + this.getCurrentBuildNumber();
    }

    public String getBuildDescription() {
        if (this.currentBuild != null) {
            return this.currentBuild.toString();
        }
        return Strings.getString("PipelineBuild.PendingBuildOfProject") + this.getProject().getName();
    }

    public long getBuildProgress() {
        if (this.currentBuild != null && this.currentBuild.isBuilding()) {
            long duration = new Date().getTime() - this.currentBuild.getTimestamp().getTimeInMillis();
            return this.calculatePercentage(duration, this.currentBuild.getEstimatedDuration());
        }
        return 0L;
    }

    protected long calculatePercentage(long duration, long estimatedDuration) {
        if (duration > estimatedDuration) {
            return 100L;
        }
        if (estimatedDuration > 0L) {
            return (long)((float)duration / (float)estimatedDuration * 100.0f);
        }
        return 100L;
    }

    public String getPipelineVersion() {
        String displayName;
        String version = this.currentBuild != null ? ((displayName = this.currentBuild.getDisplayName()) == null || displayName.trim().length() == 0 ? (this.currentBuild.getNumber() > 0 ? String.valueOf(this.currentBuild.getNumber()) : Strings.getString("PipelineBuild.RevisionNotAvailable")) : displayName) : Strings.getString("PipelineBuild.RevisionNotAvailable");
        return version;
    }

    public boolean hasBuildPermission() {
        boolean buildPermission = false;
        if (!Hudson.getInstance().isUseSecurity()) {
            LOGGER.fine("Security is not enabled.");
            buildPermission = true;
        } else if (this.project != null) {
            buildPermission = this.project.hasPermission(Item.BUILD);
        }
        LOGGER.fine("Is user allowed to build? -> " + buildPermission);
        return buildPermission;
    }

    public boolean isReadyToBeManuallyBuilt() {
        return this.currentBuild == null && (this.upstreamBuildSucceeded() || this.upstreamBuildUnstable()) && this.hasBuildPermission();
    }

    public boolean isRerunnable() {
        return !this.isReadyToBeManuallyBuilt() && !"PENDING".equals(this.getCurrentBuildResult()) && !"BUILDING".equals(this.getCurrentBuildResult()) && this.hasBuildPermission();
    }

    private boolean upstreamBuildSucceeded() {
        return this.getUpstreamBuild() != null && HudsonResult.SUCCESS.toString().equals(this.getBuildResult(this.upstreamBuild));
    }

    private boolean upstreamBuildUnstable() {
        return this.getUpstreamBuild() != null && HudsonResult.UNSTABLE.toString().equals(this.getBuildResult(this.upstreamBuild));
    }

    public boolean isManualTrigger() {
        boolean manualTrigger = false;
        if (this.upstreamBuild != null) {
            manualTrigger = ProjectUtil.isManualTrigger(this.upstreamBuild.getProject(), this.project);
        }
        return manualTrigger;
    }

    public Date getStartTime() {
        return this.currentBuild != null ? this.currentBuild.getTime() : null;
    }

    public String getFormattedStartTime() {
        String formattedStartTime = "";
        if (this.getStartTime() != null) {
            formattedStartTime = DateFormat.getTimeInstance(2).format(this.getStartTime());
        }
        return formattedStartTime;
    }

    public String getFormattedStartDate() {
        String formattedStartTime = "";
        if (this.getStartTime() != null) {
            formattedStartTime = DateFormat.getDateInstance(2).format(this.getStartTime());
        }
        return formattedStartTime;
    }

    public boolean isProjectDisabled() {
        return this.getProject().isDisabled();
    }

    public String getProjectHealth() {
        return this.project.getBuildHealth().getIconUrl().replaceAll("\\.gif", "\\.png");
    }
}

