/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.buildnamesetter;

import hudson.Extension;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import org.apache.commons.lang3.BooleanUtils;
import org.jenkinsci.plugins.buildnamesetter.Executor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class BuildNameSetter
extends BuildWrapper
implements MatrixAggregatable {
    private String template;
    private String descriptionTemplate;
    private Boolean runAtStart = true;
    private Boolean runAtEnd = true;

    @DataBoundConstructor
    public BuildNameSetter(String template, Boolean runAtStart, Boolean runAtEnd) {
        this.template = template;
        this.runAtStart = BooleanUtils.toBooleanDefaultIfNull((Boolean)runAtStart, (boolean)true);
        this.runAtEnd = BooleanUtils.toBooleanDefaultIfNull((Boolean)runAtEnd, (boolean)true);
    }

    @DataBoundSetter
    public void setDescriptionTemplate(String descriptionTemplate) {
        this.descriptionTemplate = descriptionTemplate;
    }

    public String getDescriptionTemplate() {
        return this.descriptionTemplate;
    }

    @DataBoundSetter
    public void setTemplate(String template) {
        this.template = template;
    }

    public String getTemplate() {
        return this.template;
    }

    public Boolean getRunAtStart() {
        return this.runAtStart;
    }

    public Boolean getRunAtEnd() {
        return this.runAtEnd;
    }

    protected Object readResolve() {
        if (this.runAtStart == null) {
            this.runAtStart = true;
        }
        if (this.runAtEnd == null) {
            this.runAtEnd = true;
        }
        return this;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) {
        final Executor executor = new Executor((Run)build, (TaskListener)listener);
        if (this.runAtStart.booleanValue()) {
            executor.setName(this.template);
            executor.setDescription(this.descriptionTemplate);
        }
        return new BuildWrapper.Environment(this){
            final /* synthetic */ BuildNameSetter this$0;
            {
                this.this$0 = this$0;
                super((BuildWrapper)this$0);
            }

            public boolean tearDown(AbstractBuild build, BuildListener listener) {
                if (this.this$0.runAtEnd.booleanValue()) {
                    executor.setName(this.this$0.template);
                    executor.setDescription(this.this$0.descriptionTemplate);
                }
                return true;
            }
        };
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        final Executor executor = new Executor((Run)build, (TaskListener)listener);
        return new MatrixAggregator(this, build, launcher, listener){
            final /* synthetic */ BuildNameSetter this$0;
            {
                this.this$0 = this$0;
                super(build, launcher, listener);
            }

            public boolean startBuild() throws InterruptedException, IOException {
                executor.setName(this.this$0.template);
                executor.setDescription(this.this$0.descriptionTemplate);
                return super.startBuild();
            }

            public boolean endBuild() throws InterruptedException, IOException {
                executor.setName(this.this$0.template);
                executor.setDescription(this.this$0.descriptionTemplate);
                return super.endBuild();
            }
        };
    }

    @Extension
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return "Set Build Name";
        }
    }
}

