/*
 * Decompiled with CFR 0.152.
 */
package com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.features.headline;

import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.BuildViewModel;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.JobView;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.features.headline.CandidateHeadline;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.features.headline.Headline;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.features.headline.HeadlineConfig;
import hudson.model.Result;
import hudson.model.User;
import java.util.Optional;
import jenkins.model.CauseOfInterruption;
import jenkins.model.InterruptedBuildAction;

public class HeadlineOfAborted
implements CandidateHeadline {
    private final JobView job;
    private final HeadlineConfig config;

    public HeadlineOfAborted(JobView job, HeadlineConfig config) {
        this.job = job;
        this.config = config;
    }

    @Override
    public boolean isApplicableTo(JobView job) {
        return Result.ABORTED.equals(job.lastBuild().result());
    }

    @Override
    public Headline asJson() {
        return new Headline(this.text(this.job.lastBuild()));
    }

    private String text(BuildViewModel build) {
        Optional<String> username;
        Optional<InterruptedBuildAction> interruption = build.detailsOf(InterruptedBuildAction.class);
        if (this.config.displayCommitters && interruption.isPresent() && (username = this.userResponsibleFor(interruption.get())).isPresent()) {
            return String.format("Execution aborted by %s", username.get());
        }
        return "Execution aborted";
    }

    private Optional<String> userResponsibleFor(InterruptedBuildAction details) {
        CauseOfInterruption cause;
        if (details.getCauses().size() == 1 && (cause = (CauseOfInterruption)details.getCauses().get(0)) instanceof CauseOfInterruption.UserInterruption) {
            User user = ((CauseOfInterruption.UserInterruption)cause).getUser();
            return Optional.of(user.getFullName());
        }
        return Optional.empty();
    }
}

