/*
 * Decompiled with CFR 0.152.
 */
package com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel;

import com.smartcodeltd.jenkinsci.plugins.buildmonitor.Config;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.facade.StaticJenkinsAPIs;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.JobView;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.features.CanBeClaimed;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.features.CanBeDiagnosedForProblems;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.features.Feature;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.features.HasBadgesBadgePlugin;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.features.HasConfig;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.features.HasHeadline;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.features.HasJunitRealtime;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.features.KnowsCurrentBuildsDetails;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.features.KnowsLastCompletedBuildDetails;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.features.headline.HeadlineConfig;
import hudson.model.Job;
import java.util.ArrayList;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

public class JobViews {
    private static final String Claim = "claim";
    private static final String Build_Failure_Analyzer = "build-failure-analyzer";
    private static final String Badge_Plugin = "badge";
    private static final String Pipeline = "workflow-job";
    private static final String Junit_Realtime = "junit-realtime-test-reporter";
    private final StaticJenkinsAPIs jenkins;
    private final Config config;

    public JobViews(StaticJenkinsAPIs jenkins, Config config) {
        this.jenkins = jenkins;
        this.config = config;
    }

    public JobView viewOf(Job<?, ?> job) {
        ArrayList<Feature> viewFeatures = new ArrayList<Feature>();
        viewFeatures.add(new HasConfig(this.config));
        viewFeatures.add(new HasHeadline(new HeadlineConfig(this.config.getDisplayCommitters())));
        viewFeatures.add(new KnowsLastCompletedBuildDetails());
        viewFeatures.add(new KnowsCurrentBuildsDetails());
        if (this.jenkins.hasPlugin(Claim)) {
            viewFeatures.add(new CanBeClaimed());
        }
        if (this.jenkins.hasPlugin(Build_Failure_Analyzer)) {
            viewFeatures.add(new CanBeDiagnosedForProblems(this.config.getBuildFailureAnalyzerDisplayedField()));
        }
        if (this.config.getDisplayBadges() != Config.DisplayOptions.Never && this.jenkins.hasPlugin(Badge_Plugin)) {
            viewFeatures.add(new HasBadgesBadgePlugin(this.config));
        }
        if (this.config.getDisplayJUnitProgress() && this.jenkins.hasPlugin(Junit_Realtime)) {
            viewFeatures.add(new HasJunitRealtime());
        }
        boolean isPipelineJob = this.jenkins.hasPlugin(Pipeline) && job instanceof WorkflowJob;
        return JobView.of(job, viewFeatures, isPipelineJob);
    }
}

