/*
 * Decompiled with CFR 0.152.
 */
package com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel;

import com.smartcodeltd.jenkinsci.plugins.buildmonitor.culprits.BuildCulpritsRetriever;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.facade.RelativeLocation;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.facade.StaticJenkinsAPIs;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.pipeline.PipelineHelper;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.BuildViewModel;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.duration.Duration;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.duration.DurationInMilliseconds;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.duration.HumanReadableDuration;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class BuildView
implements BuildViewModel {
    private final Run<?, ?> build;
    private final boolean isPipeline;
    private final RelativeLocation parentJobLocation;
    private final Date systemTime;
    private final BuildCulpritsRetriever buildCulpritsRetriever;

    static BuildView of(Run<?, ?> build) {
        return new BuildView(build, false, RelativeLocation.of(build.getParent()), new Date());
    }

    public static BuildView of(Run<?, ?> build, boolean isPipeline, RelativeLocation parentJobLocation, Date systemTime) {
        return new BuildView(build, isPipeline, parentJobLocation, systemTime);
    }

    @Override
    public String name() {
        return this.build.getDisplayName();
    }

    @Override
    public String url() {
        return this.parentJobLocation.url() + "/" + this.build.getNumber() + "/";
    }

    @Override
    public Result result() {
        return this.build.getResult();
    }

    @Override
    public boolean isRunning() {
        return this.isRunning(this.build);
    }

    private boolean isRunning(Run<?, ?> build) {
        return build.hasntStartedYet() || build.isBuilding() || build.isLogUpdated();
    }

    @Override
    public Duration elapsedTime() {
        return new HumanReadableDuration(this.now() - this.whenTheBuildStarted());
    }

    @Override
    public Duration timeElapsedSince() {
        return new DurationInMilliseconds(this.now() - (this.whenTheBuildStarted() + this.build.getDuration()));
    }

    @Override
    public Duration duration() {
        return new HumanReadableDuration(this.build.getDuration());
    }

    @Override
    public Duration estimatedDuration() {
        return new HumanReadableDuration(this.build.getEstimatedDuration());
    }

    @Override
    public int progress() {
        if (!this.isRunning()) {
            return 0;
        }
        if (this.isTakingLongerThanUsual()) {
            return 100;
        }
        long elapsedTime = this.now() - this.whenTheBuildStarted();
        long estimatedDuration = this.build.getEstimatedDuration();
        if (estimatedDuration > 0L) {
            return (int)((float)elapsedTime / (float)estimatedDuration * 100.0f);
        }
        return 100;
    }

    @Override
    public String description() {
        return Optional.ofNullable(this.build.getDescription()).orElse("");
    }

    @Override
    public boolean isPipeline() {
        return this.isPipeline;
    }

    @Override
    public List<String> pipelineStages() {
        if (PipelineHelper.isWorkflowRun(this.build, new StaticJenkinsAPIs())) {
            return PipelineHelper.getPipelines(this.build);
        }
        return List.of();
    }

    private boolean isTakingLongerThanUsual() {
        return this.elapsedTime().greaterThan(this.estimatedDuration());
    }

    @Override
    public boolean hasPreviousBuild() {
        return null != this.build.getPreviousBuild();
    }

    @Override
    public BuildViewModel previousBuild() {
        return new BuildView(this.build.getPreviousBuild(), this.isPipeline, this.parentJobLocation, this.systemTime);
    }

    @Override
    public Set<String> culprits() {
        return this.buildCulpritsRetriever.getCulprits(this.build);
    }

    @Override
    public Set<String> committers() {
        return this.buildCulpritsRetriever.getCommitters(this.build);
    }

    @Override
    public <A extends Action> Optional<A> detailsOf(Class<A> jenkinsAction) {
        return Optional.ofNullable(this.build.getAction(jenkinsAction));
    }

    @Override
    public <A extends Action> List<A> allDetailsOf(Class<A> jenkinsAction) {
        return this.build.getActions(jenkinsAction);
    }

    public String toString() {
        return this.name();
    }

    private long now() {
        return this.systemTime.getTime();
    }

    private long whenTheBuildStarted() {
        return this.build.getTimestamp().getTimeInMillis();
    }

    private BuildView(Run<?, ?> build, boolean isPipeline, RelativeLocation parentJobLocation, Date systemTime) {
        this.build = build;
        this.isPipeline = isPipeline;
        this.parentJobLocation = parentJobLocation;
        this.systemTime = systemTime;
        this.buildCulpritsRetriever = BuildCulpritsRetriever.getInstanceForRun(build, new StaticJenkinsAPIs());
    }
}

