/*
 * Decompiled with CFR 0.152.
 */
package com.smartcodeltd.jenkinsci.plugins.buildmonitor.pipeline;

import com.smartcodeltd.jenkinsci.plugins.buildmonitor.facade.StaticJenkinsAPIs;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.pipeline.WorkflowNodeTraversal;
import hudson.model.Run;
import java.util.List;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class PipelineHelper {
    private static final String PIPELINE_PLUGIN = "workflow-job";
    private static final String WORKFLOW_RUN_CLASS_NAME = "org.jenkinsci.plugins.workflow.job.WorkflowRun";
    private static Boolean hasWorkflowClass = null;
    private static Class<?> workflowRunClass = null;

    private PipelineHelper() {
    }

    public static boolean isWorkflowRun(Run<?, ?> build, StaticJenkinsAPIs staticJenkinsAPIs) {
        if (hasWorkflowClass == null) {
            if (!staticJenkinsAPIs.hasPlugin(PIPELINE_PLUGIN)) {
                hasWorkflowClass = false;
                return false;
            }
            try {
                workflowRunClass = Class.forName(WORKFLOW_RUN_CLASS_NAME);
                hasWorkflowClass = true;
            }
            catch (ClassNotFoundException e) {
                hasWorkflowClass = false;
                return false;
            }
        }
        if (hasWorkflowClass.booleanValue()) {
            return workflowRunClass.isInstance(build);
        }
        return false;
    }

    public static List<String> getPipelines(Run<?, ?> run) {
        WorkflowRun currentBuild = (WorkflowRun)run;
        FlowExecution execution = currentBuild.getExecution();
        if (execution != null) {
            WorkflowNodeTraversal traversal = new WorkflowNodeTraversal();
            traversal.start(execution.getCurrentHeads());
            return traversal.getStages();
        }
        return List.of();
    }
}

