/*
 * Decompiled with CFR 0.152.
 */
package com.smartcodeltd.jenkinsci.plugins.buildmonitor.order;

import com.smartcodeltd.jenkinsci.plugins.buildmonitor.order.BaseOrder;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Job;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

public class ByEstimatedDuration
extends BaseOrder
implements Comparator<Job<?, ?>>,
Serializable {
    @DataBoundConstructor
    public ByEstimatedDuration() {
    }

    @Override
    public int compare(Job<?, ?> a, Job<?, ?> b) {
        return this.compareEstimatedDuration((AbstractProject)a, (AbstractProject)b);
    }

    private long getTotalEstimatedDuration(AbstractProject<?, ?> project) {
        long time = project.getEstimatedDuration();
        if (!project.getUpstreamProjects().isEmpty()) {
            List upStreamProjects = project.getUpstreamProjects();
            for (AbstractProject upStreamProject : upStreamProjects) {
                time += this.getTotalEstimatedDuration(upStreamProject);
            }
        }
        return time;
    }

    private int compareEstimatedDuration(AbstractProject<?, ?> a, AbstractProject<?, ?> b) {
        return Long.compare(this.getTotalEstimatedDuration(a), this.getTotalEstimatedDuration(b));
    }

    @Extension
    public static class ByEstimatedDurationDescriptor
    extends Descriptor<BaseOrder> {
    }
}

