/*
 * Decompiled with CFR 0.152.
 */
package com.smartcodeltd.jenkinsci.plugins.buildmonitor.installation;

import com.smartcodeltd.jenkinsci.plugins.buildmonitor.facade.StaticJenkinsAPIs;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.installation.Audience;
import org.apache.commons.codec.digest.DigestUtils;

public class BuildMonitorInstallation {
    private static final String UNKNOWN = "unknown";
    private String anonymousCorrelationId = "unknown";
    private final StaticJenkinsAPIs jenkins;

    public BuildMonitorInstallation() {
        this(new StaticJenkinsAPIs());
    }

    public BuildMonitorInstallation(StaticJenkinsAPIs jenkinsAPIs) {
        this.jenkins = jenkinsAPIs;
    }

    public String anonymousCorrelationId() {
        if (UNKNOWN.equalsIgnoreCase(this.anonymousCorrelationId)) {
            this.anonymousCorrelationId = DigestUtils.sha256Hex((String)this.jenkins.encodedPublicKey());
        }
        return this.anonymousCorrelationId;
    }

    public int size() {
        return this.jenkins.numberOfUsers();
    }

    public Audience audience() {
        return this.jenkins.isDevelopmentMode() || this.buildMonitorVersion().contains("SNAPSHOT") ? Audience.BuildMonitorDevelopers : Audience.EndUsers;
    }

    public String buildMonitorVersion() {
        return this.jenkins.getPluginVersion("build-monitor-plugin");
    }
}

