/*
 * Decompiled with CFR 0.152.
 */
package com.smartcodeltd.jenkinsci.plugins.buildmonitor.culprits;

import com.smartcodeltd.jenkinsci.plugins.buildmonitor.culprits.BuildCulpritsRetriever;
import hudson.model.Result;
import hudson.model.Run;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

class BuildCulpritsWorkflowRun
extends BuildCulpritsRetriever {
    BuildCulpritsWorkflowRun() {
    }

    @Override
    public Set<String> getCulprits(Run<?, ?> run) {
        Result previousResult;
        WorkflowRun workflowRun = (WorkflowRun)run;
        TreeSet<String> culprits = new TreeSet<String>();
        WorkflowRun previous = (WorkflowRun)workflowRun.getPreviousCompletedBuild();
        if (workflowRun.isBuilding() && previous != null && (previousResult = previous.getResult()) != null && previousResult.isWorseThan(Result.SUCCESS)) {
            culprits.addAll(this.getCommitters((Run<?, ?>)previous));
        }
        culprits.addAll(this.getCommitters((Run<?, ?>)workflowRun));
        if (previous != null && previous.getPreviousNotFailedBuild() != null) {
            culprits.addAll(this.getCulpritsForRun((WorkflowRun)previous.getPreviousNotFailedBuild(), previous));
        }
        return culprits;
    }

    @Override
    protected Set<String> getCommittersForRun(Run<?, ?> run) {
        WorkflowRun workflowRun = (WorkflowRun)run;
        return workflowRun.getChangeSets().stream().filter(Objects::nonNull).flatMap(changeLogSet -> StreamSupport.stream(changeLogSet.spliterator(), false)).map(entry -> entry != null ? entry.getAuthor().getFullName() : null).collect(Collectors.toCollection(TreeSet::new));
    }

    private Set<String> getCulpritsForRun(WorkflowRun from, WorkflowRun to) {
        TreeSet<String> culprits = new TreeSet<String>();
        WorkflowRun next = null;
        while (true) {
            WorkflowRun workflowRun = next = next == null ? from.getNextBuild() : next.getNextBuild();
            if (next == null || next.getNumber() >= to.getNumber()) break;
            culprits.addAll(this.getCommitters((Run<?, ?>)next));
        }
        return culprits;
    }
}

