/*
 * Decompiled with CFR 0.152.
 */
package com.smartcodeltd.jenkinsci.plugins.buildmonitor;

import com.smartcodeltd.jenkinsci.plugins.buildmonitor.BuildMonitorView;
import hudson.Util;
import hudson.model.ViewDescriptor;
import hudson.util.FormValidation;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public final class BuildMonitorDescriptor
extends ViewDescriptor {
    private boolean permissionToCollectAnonymousUsageStatistics = true;

    public BuildMonitorDescriptor() {
        super(BuildMonitorView.class);
        this.load();
    }

    public String getDisplayName() {
        return "Build Monitor View";
    }

    public FormValidation doCheckIncludeRegex(@QueryParameter String value) {
        String v = Util.fixEmpty((String)value);
        if (v != null) {
            try {
                Pattern.compile(v);
            }
            catch (PatternSyntaxException pse) {
                return FormValidation.error((String)pse.getMessage());
            }
        }
        return FormValidation.ok();
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) {
        req.bindJSON((Object)this, json.getJSONObject("build-monitor"));
        this.save();
        return true;
    }

    public boolean getPermissionToCollectAnonymousUsageStatistics() {
        return this.permissionToCollectAnonymousUsageStatistics;
    }

    public void setPermissionToCollectAnonymousUsageStatistics(boolean collect) {
        this.permissionToCollectAnonymousUsageStatistics = collect;
    }

    public FormValidation doCheckMaxColumns(@QueryParameter String value) {
        String v = Util.fixEmpty((String)value);
        if (v != null) {
            try {
                int intValue = Integer.parseInt(v);
                if (intValue > 0) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)"Must be an integer, greater than 0.");
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Must be an integer.");
            }
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckTextScale(@QueryParameter String value) {
        String v = Util.fixEmpty((String)value);
        if (v != null) {
            try {
                double doubleValue = Double.parseDouble(v);
                if (doubleValue > 0.0) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)"Must be a double, greater than 0.0.");
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Must be a double.");
            }
        }
        return FormValidation.ok();
    }
}

