/*
 * Decompiled with CFR 0.152.
 */
package com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.features.headline;

import com.smartcodeltd.jenkinsci.plugins.buildmonitor.readability.Lister;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.BuildViewModel;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.JobView;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.features.headline.CandidateHeadline;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.features.headline.Headline;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.features.headline.HeadlineConfig;
import hudson.model.Result;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class HeadlineOfFixed
implements CandidateHeadline {
    private final JobView job;
    private final HeadlineConfig config;

    public HeadlineOfFixed(JobView job, HeadlineConfig config) {
        this.job = job;
        this.config = config;
    }

    @Override
    public boolean isApplicableTo(JobView job) {
        return this.didTheJobJustGetFixedWith(job.lastCompletedBuild());
    }

    @Override
    public Headline asJson() {
        return new Headline(this.textFor(this.job.lastCompletedBuild()));
    }

    private String textFor(BuildViewModel lastBuild) {
        return Lister.describe("Back in the green!", "Fixed after %s committed their changes :-)", new LinkedList<String>(this.committersOf(lastBuild)));
    }

    private boolean didTheJobJustGetFixedWith(BuildViewModel build) {
        return Result.SUCCESS.equals(build.result()) && this.previousFailed(build);
    }

    private boolean previousFailed(BuildViewModel build) {
        return build.hasPreviousBuild() && (Result.FAILURE.equals(build.previousBuild().result()) || Result.UNSTABLE.equals(build.previousBuild().result()) || Result.ABORTED.equals(build.previousBuild().result()));
    }

    private Set<String> committersOf(BuildViewModel build) {
        return this.config.displayCommitters ? build.committers() : new HashSet<String>();
    }
}

