/*
 * Decompiled with CFR 0.152.
 */
package com.smartcodeltd.jenkinsci.plugins.buildmonitor.order;

import com.smartcodeltd.jenkinsci.plugins.buildmonitor.order.BaseOrder;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import java.io.Serializable;
import java.util.Comparator;
import org.kohsuke.stapler.DataBoundConstructor;

public class ByStatus
extends BaseOrder
implements Comparator<Job<?, ?>>,
Serializable {
    @DataBoundConstructor
    public ByStatus() {
    }

    @Override
    public int compare(Job<?, ?> a, Job<?, ?> b) {
        return this.bothProjectsHaveBuildHistory(a, b) ? this.compareRecentlyCompletedBuilds(a, b) : this.compareProjects(a, b);
    }

    private boolean bothProjectsHaveBuildHistory(Job<?, ?> a, Job<?, ?> b) {
        return a.getLastCompletedBuild() != null && b.getLastCompletedBuild() != null;
    }

    private int compareProjects(Job<?, ?> a, Job<?, ?> b) {
        Run recentBuildOfA = a.getLastCompletedBuild();
        Run recentBuildOfB = b.getLastCompletedBuild();
        if (recentBuildOfA == null && recentBuildOfB != null) {
            return -1;
        }
        if (recentBuildOfA != null && recentBuildOfB == null) {
            return 1;
        }
        return 0;
    }

    private int compareRecentlyCompletedBuilds(Job<?, ?> a, Job<?, ?> b) {
        Result lastResultOfA = a.getLastCompletedBuild().getResult();
        Result lastResultOfB = b.getLastCompletedBuild().getResult();
        if (lastResultOfA == null && lastResultOfB == null) {
            return 0;
        }
        if (lastResultOfA == null) {
            return -1;
        }
        if (lastResultOfB == null) {
            return 1;
        }
        if (lastResultOfA.isWorseThan(lastResultOfB)) {
            return -1;
        }
        if (lastResultOfA.isBetterThan(lastResultOfB)) {
            return 1;
        }
        return 0;
    }

    @Extension
    public static class ByStatusDescriptor
    extends Descriptor<BaseOrder> {
    }
}

