/*
 * Decompiled with CFR 0.152.
 */
package com.smartcodeltd.jenkinsci.plugins.buildmonitor;

import com.smartcodeltd.jenkinsci.plugins.buildmonitor.build.GetBuildViewModel;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.build.GetLastBuild;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.order.BaseOrder;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.order.ByName;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Job;
import java.util.Comparator;
import java.util.Optional;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class Config
implements Describable<Config> {
    private Boolean colourBlindMode;
    private Boolean displayCommitters;
    private Boolean reduceMotion;
    private Integer maxColumns;
    private Double textScale;
    private Boolean showBadges;
    private DisplayOptions displayBadges;
    private GetBuildViewModel displayBadgesFrom;
    private BuildFailureAnalyzerDisplayedField buildFailureAnalyzerDisplayedField;
    private Boolean displayJUnitProgress;
    private BaseOrder order;

    public static Config defaultConfig() {
        return new Config();
    }

    public Descriptor<Config> getDescriptor() {
        return Jenkins.get().getDescriptor(this.getClass());
    }

    @DataBoundConstructor
    public Config() {
    }

    public Comparator<Job<?, ?>> getOrder() {
        return Optional.ofNullable(this.order).orElse(new ByName());
    }

    public void setOrder(BaseOrder order) {
        this.order = order;
    }

    public BuildFailureAnalyzerDisplayedField getBuildFailureAnalyzerDisplayedField() {
        return Optional.ofNullable(this.buildFailureAnalyzerDisplayedField).orElse(BuildFailureAnalyzerDisplayedField.Name);
    }

    public void setBuildFailureAnalyzerDisplayedField(String buildFailureAnalyzerDisplayedField) {
        this.buildFailureAnalyzerDisplayedField = BuildFailureAnalyzerDisplayedField.valueOf(buildFailureAnalyzerDisplayedField);
    }

    public boolean getColourBlindMode() {
        return Optional.ofNullable(this.colourBlindMode).orElse(false);
    }

    public void setColourBlindMode(boolean flag) {
        this.colourBlindMode = flag;
    }

    public boolean getDisplayCommitters() {
        return Optional.ofNullable(this.displayCommitters).orElse(true);
    }

    public void setDisplayCommitters(boolean flag) {
        this.displayCommitters = flag;
    }

    public boolean getReduceMotion() {
        return Optional.ofNullable(this.reduceMotion).orElse(false);
    }

    public void setReduceMotion(boolean flag) {
        this.reduceMotion = flag;
    }

    public boolean getShowBadges() {
        return Optional.ofNullable(this.showBadges).orElse(true);
    }

    public void setShowBadges(boolean flag) {
        this.showBadges = flag;
    }

    public DisplayOptions getDisplayBadges() {
        return Optional.ofNullable(this.displayBadges).orElse(DisplayOptions.UserSetting);
    }

    public void setDisplayBadges(String option) {
        this.displayBadges = DisplayOptions.valueOf(option);
    }

    public GetBuildViewModel getDisplayBadgesFrom() {
        return Optional.ofNullable(this.displayBadgesFrom).orElse(new GetLastBuild());
    }

    public void setDisplayBadgesFrom(GetBuildViewModel displayBadgesFrom) {
        this.displayBadgesFrom = displayBadgesFrom;
    }

    public boolean getDisplayJUnitProgress() {
        return Optional.ofNullable(this.displayJUnitProgress).orElse(true);
    }

    public void setDisplayJUnitProgress(boolean flag) {
        this.displayJUnitProgress = flag;
    }

    public int getMaxColumns() {
        return Optional.ofNullable(this.maxColumns).orElse(2);
    }

    public void setMaxColumns(int maxColumns) {
        this.maxColumns = maxColumns;
    }

    public double getTextScale() {
        return Optional.ofNullable(this.textScale).orElse(1.0);
    }

    public void setTextScale(double scale) {
        this.textScale = scale;
    }

    public String toString() {
        return String.format("Config{order=%s}", this.order.getClass().getSimpleName());
    }

    public static enum BuildFailureAnalyzerDisplayedField {
        Name("name"),
        Description("description"),
        None("none");

        private final String value;

        private BuildFailureAnalyzerDisplayedField(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum DisplayOptions {
        Always,
        Never,
        UserSetting;

    }

    @Extension
    public static class ConfigDescriptor
    extends Descriptor<Config> {
    }
}

