/*
 * Decompiled with CFR 0.152.
 */
package com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.features;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.BuildViewModel;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.JobView;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.duration.Duration;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.features.Feature;
import java.util.ArrayList;
import java.util.List;

public class KnowsCurrentBuildsDetails
implements Feature<CurrentBuilds> {
    private JobView job;

    @Override
    public KnowsCurrentBuildsDetails of(JobView jobView) {
        this.job = jobView;
        return this;
    }

    @Override
    public CurrentBuilds asJson() {
        return new CurrentBuilds(this.job.currentBuilds());
    }

    private static String formattedDuration(Duration duration) {
        return null != duration ? duration.value() : "";
    }

    private static String formattedStages(List<String> stages) {
        if (!stages.isEmpty()) {
            return "[" + String.join((CharSequence)", ", stages) + "]";
        }
        return "";
    }

    public static class CurrentBuilds {
        private final List<CurrentBuild> builds = new ArrayList<CurrentBuild>();

        public CurrentBuilds(List<BuildViewModel> currentBuilds) {
            for (BuildViewModel currentBuild : currentBuilds) {
                this.builds.add(new CurrentBuild(currentBuild));
            }
        }

        @JsonValue
        public List<CurrentBuild> value() {
            return List.copyOf(this.builds);
        }
    }

    public static class CurrentBuild {
        private final BuildViewModel build;

        public CurrentBuild(BuildViewModel build) {
            this.build = build;
        }

        @JsonProperty
        public final String name() {
            return this.build.name();
        }

        @JsonProperty
        public final String url() {
            return this.build.url();
        }

        @JsonProperty
        public final String duration() {
            return KnowsCurrentBuildsDetails.formattedDuration(this.build.elapsedTime());
        }

        @JsonProperty
        public final String description() {
            return this.build.description();
        }

        @JsonProperty
        public final String pipelineStages() {
            if (this.build.isPipeline()) {
                return KnowsCurrentBuildsDetails.formattedStages(this.build.pipelineStages());
            }
            return "";
        }
    }
}

