/*
 * Decompiled with CFR 0.152.
 */
package com.smartcodeltd.jenkinsci.plugins.buildmonitor.readability;

import java.util.List;

public class Lister {
    private static final String DEFAULT_NO_ITEMS_TEMPLATE = "%s";

    public static <T> String describe(String pluralTemplate, List<T> items) {
        return Lister.describe(DEFAULT_NO_ITEMS_TEMPLATE, pluralTemplate, items);
    }

    public static <T> String describe(String noItemsTemplate, String pluralTemplate, List<T> items) {
        return Lister.describe(noItemsTemplate, pluralTemplate, pluralTemplate, items);
    }

    public static <T> String describe(String noItemsTemplate, String singularTemplate, String pluralTemplate, List<T> items) {
        switch (items.size()) {
            case 0: {
                return Lister.formatted(noItemsTemplate, items);
            }
            case 1: {
                return Lister.formatted(singularTemplate, items);
            }
        }
        return Lister.formatted(pluralTemplate, items);
    }

    public static <T> String asString(List<T> items) {
        return items.isEmpty() ? "" : Lister.asString(Lister.headOf(items), Lister.restOf(items));
    }

    private static <T> String formatted(String template, List<T> items) {
        return String.format(template, Lister.asString(items));
    }

    private static <T> String asString(String acc, List<T> tail) {
        switch (tail.size()) {
            case 0: {
                return acc;
            }
            case 1: {
                return Lister.and(acc, Lister.headOf(tail));
            }
        }
        return Lister.asString(Lister.comma(acc, Lister.headOf(tail)), Lister.restOf(tail));
    }

    private static String and(String first, String second) {
        return String.format("%s and %s", first, second);
    }

    private static String comma(String first, String second) {
        return String.format("%s, %s", first, second);
    }

    private static <T> String headOf(List<T> items) {
        return items.get(0).toString();
    }

    private static <T> List<T> restOf(List<T> items) {
        return items.subList(1, items.size());
    }
}

