/*
 * Decompiled with CFR 0.152.
 */
package com.smartcodeltd.jenkinsci.plugins.buildmonitor;

import com.smartcodeltd.jenkinsci.plugins.buildmonitor.BuildMonitorDescriptor;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.Config;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.api.Respond;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.build.GetBuildViewModel;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.facade.StaticJenkinsAPIs;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.installation.BuildMonitorInstallation;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.order.BaseOrder;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.JobView;
import com.smartcodeltd.jenkinsci.plugins.buildmonitor.viewmodel.JobViews;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.ListView;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class BuildMonitorView
extends ListView {
    @Extension
    public static final BuildMonitorDescriptor descriptor = new BuildMonitorDescriptor();
    private String title;
    private static final BuildMonitorInstallation installation = new BuildMonitorInstallation();
    private Config config;
    @Deprecated
    private Comparator<Job<?, ?>> order;

    @DataBoundConstructor
    public BuildMonitorView(String name, String title) {
        super(name);
        this.title = title;
    }

    public String getTitle() {
        return this.isGiven(this.title) ? this.title : this.getDisplayName();
    }

    public boolean isEmpty() {
        return this.jobViews().isEmpty();
    }

    public String getCsrfCrumbFieldName() {
        return new StaticJenkinsAPIs().crumbFieldName();
    }

    public String currentOrder() {
        return this.currentConfig().getOrder().getClass().getSimpleName();
    }

    public String currentbuildFailureAnalyzerDisplayedField() {
        return this.currentConfig().getBuildFailureAnalyzerDisplayedField().getValue();
    }

    public boolean isDisplayCommitters() {
        return this.currentConfig().getDisplayCommitters();
    }

    public double getTextScale() {
        return this.currentConfig().getTextScale();
    }

    public int getMaxColumns() {
        return this.currentConfig().getMaxColumns();
    }

    public boolean isColourBlindMode() {
        return this.currentConfig().getColourBlindMode();
    }

    public boolean isReduceMotion() {
        return this.currentConfig().getReduceMotion();
    }

    public boolean isShowBadges() {
        return this.currentConfig().getShowBadges();
    }

    public String currentDisplayBadges() {
        return this.currentConfig().getDisplayBadges().name();
    }

    public String currentDisplayBadgesFrom() {
        return this.currentConfig().getDisplayBadgesFrom().getClass().getSimpleName();
    }

    public boolean isDisplayJUnitProgress() {
        return this.currentConfig().getDisplayJUnitProgress();
    }

    public BuildMonitorInstallation getInstallation() {
        return installation;
    }

    public boolean collectAnonymousUsageStatistics() {
        return descriptor.getPermissionToCollectAnonymousUsageStatistics();
    }

    protected void initColumns() {
    }

    @DataBoundSetter
    public void setConfig(Config config) {
        this.config = config;
    }

    public Config getConfig() {
        return this.currentConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submit(StaplerRequest2 req) throws ServletException, IOException, Descriptor.FormException {
        super.submit(req);
        JSONObject json = req.getSubmittedForm();
        BuildMonitorView buildMonitorView = this;
        synchronized (buildMonitorView) {
            String requestedOrdering = req.getParameter("order");
            String displayBadgesFrom = req.getParameter("displayBadgesFrom");
            this.title = req.getParameter("title");
            String maxColumns = req.getParameter("maxColumns");
            String textScale = req.getParameter("textScale");
            this.currentConfig().setColourBlindMode(json.optBoolean("colourBlindMode", false));
            this.currentConfig().setReduceMotion(json.optBoolean("reduceMotion", false));
            this.currentConfig().setShowBadges(json.optBoolean("showBadges", true));
            this.currentConfig().setDisplayBadges(req.getParameter("displayBadges"));
            this.currentConfig().setDisplayCommitters(json.optBoolean("displayCommitters", true));
            this.currentConfig().setBuildFailureAnalyzerDisplayedField(req.getParameter("buildFailureAnalyzerDisplayedField"));
            this.currentConfig().setDisplayJUnitProgress(json.optBoolean("displayJUnitProgress", true));
            try {
                this.currentConfig().setOrder(this.orderIn(requestedOrdering));
            }
            catch (Exception e) {
                throw new Descriptor.FormException("Can't order projects by " + requestedOrdering, "order");
            }
            try {
                this.currentConfig().setMaxColumns(Integer.parseInt(maxColumns));
            }
            catch (Exception e) {
                throw new Descriptor.FormException("Invalid value of 'Maximum number of columns': '" + maxColumns + "' (should be double).", maxColumns);
            }
            try {
                this.currentConfig().setTextScale(Double.parseDouble(textScale));
            }
            catch (Exception e) {
                throw new Descriptor.FormException("Invalid value of 'Text scale': '" + textScale + "' (should be double).", textScale);
            }
            try {
                this.currentConfig().setDisplayBadgesFrom(this.getBuildViewModelIn(displayBadgesFrom));
            }
            catch (Exception e) {
                throw new Descriptor.FormException("Can't display badges from " + displayBadgesFrom, "displayBadgesFrom");
            }
        }
    }

    @JavaScriptMethod
    public JSONObject fetchJobViews() throws Exception {
        return Respond.withSuccess(this.jobViews());
    }

    private boolean isGiven(String value) {
        return value != null && !"".equals(value);
    }

    private List<JobView> jobViews() {
        JobViews views = new JobViews(new StaticJenkinsAPIs(), this.currentConfig());
        ArrayList projects = new ArrayList(Util.filter((List)super.getItems(), Job.class));
        ArrayList<JobView> jobs = new ArrayList<JobView>();
        projects.sort(this.currentConfig().getOrder());
        for (Job job : projects) {
            jobs.add(views.viewOf(job));
        }
        return jobs;
    }

    private Config currentConfig() {
        if (this.creatingAFreshView()) {
            this.config = Config.defaultConfig();
        } else if (this.deserailisingFromAnOlderFormat()) {
            this.migrateFromOldToNewConfigFormat();
        }
        return this.config;
    }

    private boolean creatingAFreshView() {
        return this.config == null && this.order == null;
    }

    private boolean deserailisingFromAnOlderFormat() {
        return this.config == null && this.order != null;
    }

    private void migrateFromOldToNewConfigFormat() {
        Config c = new Config();
        c.setOrder((BaseOrder)this.order);
        this.config = c;
        this.order = null;
    }

    private BaseOrder orderIn(String requestedOrdering) throws ReflectiveOperationException {
        String packageName = ((Object)((Object)this)).getClass().getPackage().getName() + ".order.";
        return (BaseOrder)Class.forName(packageName + requestedOrdering).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private GetBuildViewModel getBuildViewModelIn(String requestedBuild) throws ReflectiveOperationException {
        String packageName = ((Object)((Object)this)).getClass().getPackage().getName() + ".build.";
        return (GetBuildViewModel)Class.forName(packageName + requestedBuild).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

