/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.integration.jenkins.process;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import net.serenitybdd.integration.jenkins.process.JenkinsLogWatcher;
import org.jdeferred.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsProcess {
    private static final Logger Log = LoggerFactory.getLogger(JenkinsProcess.class);
    private static final int Startup_Timeout = 300000;
    public static final String JENKINS_IS_FULLY_UP_AND_RUNNING = "Jenkins is fully up and running";
    private final ProcessBuilder process;
    private final int port;
    private Process jenkinsProcess;
    private final Thread shutdownHook = new Thread(){

        @Override
        public void run() {
            if (JenkinsProcess.this.jenkinsProcess.isAlive()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (JenkinsProcess.this.jenkinsProcess.isAlive()) {
                    JenkinsProcess.this.jenkinsProcess.destroyForcibly();
                }
            }
        }
    };
    private JenkinsLogWatcher jenkinsLogWatcher;
    private Thread jenkinsLogWatcherThread;
    private static String OS = System.getProperty("os.name").toLowerCase();

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="FindBugs does not like the JAVA_HOME resolve")
    public JenkinsProcess(@NonNull Path java, @NonNull Path jenkinsWar, @NonNull int port, @NonNull Path jenkinsHome) {
        Log.debug("jenkins.war:  {}", (Object)jenkinsWar.toAbsolutePath());
        Log.debug("JENKINS_HOME: {}", (Object)jenkinsHome.toAbsolutePath());
        this.port = port;
        Map<String, String> env = Map.of("JENKINS_HOME", jenkinsHome.toAbsolutePath().toString(), "JAVA_HOME", java.getParent().getParent().toAbsolutePath().toString());
        this.process = this.process(java, "-Duser.language=en", "-Dhudson.Main.development=true", "-Dorg.slf4j.simpleLogger.defaultLogLevel=debug", "-Djava.util.logging=DEBUG", "-Dhudson.DNSMultiCast.disabled=true", "-jar", jenkinsWar.toString(), "--httpPort=" + port, "--enable-future-java").directory(jenkinsHome.toFile());
        this.process.environment().putAll(env);
        this.process.redirectErrorStream(true);
    }

    public void start() throws IOException {
        this.jenkinsProcess = this.start(this.process);
        this.jenkinsLogWatcher = new JenkinsLogWatcher(this.jenkinsProcess.getInputStream());
        this.jenkinsLogWatcherThread = new Thread((Runnable)this.jenkinsLogWatcher, "jenkins");
        this.jenkinsLogWatcherThread.start();
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        Promise<Matcher, ?, ?> portConflictDetected = this.jenkinsLogWatcher.watchFor("java.net.BindException: Address already in use");
        Promise<Matcher, ?, ?> jenkinsStarted = this.jenkinsLogWatcher.watchFor(JENKINS_IS_FULLY_UP_AND_RUNNING);
        try {
            jenkinsStarted.waitSafely(300000L);
            if (!jenkinsStarted.isResolved()) {
                throw new RuntimeException(String.format("Jenkins failed to start within %s seconds, aborting the test.", 300000));
            }
            Log.info("Jenkins is now available at http://localhost:{}", (Object)this.port);
        }
        catch (InterruptedException e) {
            throw portConflictDetected.isResolved() ? new RuntimeException(String.format("Couldn't start Jenkins on port '%s', the port is already in use", this.port), e) : new RuntimeException("Couldn't start Jenkins", e);
        }
    }

    public Promise<Matcher, ?, ?> promiseWhen(String logLine) {
        return this.jenkinsLogWatcher.watchFor(logLine);
    }

    public void waitUntil(String logLine) {
        try {
            this.jenkinsLogWatcher.watchFor(logLine).waitSafely(300000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(String.format("Did not see '%s' in the Jenkins log within %s ms", logLine, 300000), e);
        }
    }

    public void stop() {
        Log.info("Stopping Jenkins...");
        this.jenkinsProcess.destroy();
        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        Log.info("Jenkins stopped");
    }

    private ProcessBuilder process(Path executable, String ... arguments) {
        ArrayList<String> args = new ArrayList<String>(this.windowsOrUnix(executable));
        args.addAll(List.of(arguments));
        return new ProcessBuilder(args);
    }

    private Process start(ProcessBuilder jenkinsProcessBuilder) throws IOException {
        Log.info("Starting Jenkins on port {}...", (Object)this.port);
        Process startedProcess = jenkinsProcessBuilder.start();
        startedProcess.getOutputStream().close();
        return startedProcess;
    }

    private List<String> windowsOrUnix(Path command) {
        return OS.contains("win") ? List.of("cmd.exe", "/C", command.toString()) : List.of(command.toString());
    }

    public JenkinsLogWatcher getJenkinsLogWatcher() {
        return this.jenkinsLogWatcher;
    }
}

