/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.integration.jenkins.environment;

import com.github.zafarkhaja.semver.Version;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.serenitybdd.integration.jenkins.environment.Directories;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCenter {
    private static final Logger Log = LoggerFactory.getLogger(UpdateCenter.class);
    private static final String Update_Center_URL_Template = "https://updates.jenkins.io/update-center.json?version=%s";
    private final Path tempDir;
    private List<Version> jenkinsLTSVersions = List.of(Version.valueOf((String)"2.375.4"), Version.valueOf((String)"2.375.3"), Version.valueOf((String)"2.375.2"), Version.valueOf((String)"2.375.1"), Version.valueOf((String)"2.361.4"), Version.valueOf((String)"2.361.3"), Version.valueOf((String)"2.361.2"), Version.valueOf((String)"2.361.1"), Version.valueOf((String)"2.346.3"), Version.valueOf((String)"2.346.2"), Version.valueOf((String)"2.346.1"));

    public UpdateCenter() {
        this(Directories.Default_Temp_Dir);
    }

    public UpdateCenter(Path tempDir) {
        this.tempDir = tempDir;
    }

    public String jsonFor(String jenkinsVersion) {
        try {
            return this.stripJSONPEnvelope(this.download(this.updateCenterJSONPFor(jenkinsVersion)));
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't download 'update-center.json'.", e);
        }
    }

    private URL updateCenterJSONPFor(String jenkinsVersion) throws MalformedURLException {
        String versionToUse = this.getUpdateVersionToUse(jenkinsVersion);
        URL url = this.url(Update_Center_URL_Template, versionToUse);
        Log.info("Jenkins update URL is {}", (Object)url);
        return url;
    }

    String getUpdateVersionToUse(String jenkinsVersionString) {
        Version lowestLTS;
        Version jenkinsVersion = Version.valueOf((String)jenkinsVersionString);
        if (jenkinsVersion.lessThan(lowestLTS = this.jenkinsLTSVersions.get(this.jenkinsLTSVersions.size() - 1))) {
            throw new RuntimeException("Can't test Jenkins versions lower than " + String.valueOf(lowestLTS) + ".");
        }
        Version versionToUse = null;
        for (Version ltsVersion : this.jenkinsLTSVersions) {
            if (!jenkinsVersion.greaterThanOrEqualTo(ltsVersion)) continue;
            versionToUse = ltsVersion;
            break;
        }
        assert (versionToUse != null);
        return versionToUse.getNormalVersion();
    }

    private String stripJSONPEnvelope(Path jsonp) throws IOException {
        return Files.readAllLines(jsonp, StandardCharsets.UTF_8).get(1);
    }

    private Path download(URL link) throws IOException {
        Files.createDirectories(this.tempDir, new FileAttribute[0]);
        Path destination = Files.createTempFile(this.tempDir, "", ".tmp", new FileAttribute[0]);
        ReadableByteChannel rbc = Channels.newChannel(link.openStream());
        try (FileOutputStream fos = new FileOutputStream(destination.toAbsolutePath().toFile());){
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            Path path = destination;
            return path;
        }
    }

    private URL url(String template, String ... params) throws MalformedURLException {
        return new URL(String.format(template, params));
    }
}

