/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.integration.jenkins;

import java.util.ArrayList;
import java.util.List;
import net.serenitybdd.integration.jenkins.JenkinsInstance;
import net.serenitybdd.integration.jenkins.environment.rules.ApplicativeTestRule;

public class TestEnvironment {
    private final JenkinsInstance instance;
    private final List<ApplicativeTestRule<JenkinsInstance>> rulesToBeAppliedBeforeJenkinsStart = new ArrayList<ApplicativeTestRule<JenkinsInstance>>();
    private final List<ApplicativeTestRule<JenkinsInstance>> rulesToBeAppliedAfterJenkinsStart = new ArrayList<ApplicativeTestRule<JenkinsInstance>>();

    public TestEnvironment(JenkinsInstance instance) {
        this.instance = instance;
    }

    public JenkinsInstance create() {
        return this.instance.beforeStartApply(this.rulesToBeAppliedBeforeJenkinsStart).afterStartApply(this.rulesToBeAppliedAfterJenkinsStart);
    }

    public <ATR extends ApplicativeTestRule<JenkinsInstance>> TestEnvironment beforeStart(ATR ... rules) {
        return this.beforeStart(List.of(rules));
    }

    public <ATR extends ApplicativeTestRule<JenkinsInstance>> TestEnvironment afterStart(ATR ... rules) {
        return this.afterStart(List.of(rules));
    }

    public <ATR extends ApplicativeTestRule<JenkinsInstance>> TestEnvironment beforeStart(List<ATR> rules) {
        this.rulesToBeAppliedBeforeJenkinsStart.addAll(rules);
        return this;
    }

    public <ATR extends ApplicativeTestRule<JenkinsInstance>> TestEnvironment afterStart(List<ATR> rules) {
        this.rulesToBeAppliedAfterJenkinsStart.addAll(rules);
        return this;
    }
}

