/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplayx.actions;

import java.util.HashMap;
import java.util.Map;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Interaction;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.targets.Target;
import net.serenitybdd.screenplayx.actions.Evaluate;
import org.openqa.selenium.WebElement;

public class ScrollToTarget
implements Interaction {
    private static final Map<String, String> centerAlignOptions = new HashMap<String, String>();
    private final Target target;
    private String alignTo = "middle";

    public ScrollToTarget(Target target) {
        this.target = target;
    }

    public ScrollToTarget andAlignToTop() {
        this.alignTo = "top";
        return this;
    }

    public ScrollToTarget andAlignToBottom() {
        this.alignTo = "bottom";
        return this;
    }

    public ScrollToTarget andAlignInMiddle() {
        this.alignTo = "middle";
        return this;
    }

    public <T extends Actor> void performAs(T actor) {
        actor.attemptsTo(new Performable[]{this.scrollTo((WebElement)this.target.resolveFor(actor), this.alignTo)});
    }

    private Evaluate scrollTo(WebElement element, String alignTo) {
        return Evaluate.javascript("arguments[0].scrollIntoView(arguments[1]);", element, switch (alignTo) {
            case "top" -> Boolean.TRUE;
            case "bottom" -> Boolean.FALSE;
            default -> centerAlignOptions;
        });
    }

    static {
        centerAlignOptions.put("behavior", "auto");
        centerAlignOptions.put("block", "center");
        centerAlignOptions.put("inline", "center");
    }
}

