/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.integration.jenkins.environment.rules;

import java.io.IOException;
import java.net.ServerSocket;
import net.serenitybdd.integration.jenkins.JenkinsInstance;
import net.serenitybdd.integration.jenkins.environment.rules.ApplicativeTestRule;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindFreePort
implements ApplicativeTestRule<JenkinsInstance> {
    private static final Logger Log = LoggerFactory.getLogger(FindFreePort.class);
    private static final int Dynamic_Range_Start = 49152;
    private static final int Dynamic_Range_End = 65535;
    private final int rangeStart;
    private final int rangeEnd;

    public static FindFreePort useFreePortFromDynamicRange() {
        return new FindFreePort(49152, 65535);
    }

    public static FindFreePort useFreePortFromTheFollowingRange(int rangeStart, int rangeEnd) {
        return new FindFreePort(rangeStart, rangeEnd);
    }

    public FindFreePort(int rangeStart, int rangeEnd) {
        if (rangeStart > rangeEnd) {
            throw new IllegalArgumentException(String.format("Start of the port range (%d) should be lower than the end of the range (%d)", rangeStart, rangeEnd));
        }
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
    }

    @Override
    public TestRule applyTo(final JenkinsInstance instance) {
        return new TestWatcher(){

            protected void starting(Description description) {
                int portNumber = FindFreePort.this.anyFreeLocalPortInRange(FindFreePort.this.rangeStart, FindFreePort.this.rangeEnd);
                Log.info("Found a free port: {}", (Object)portNumber);
                instance.setPort(portNumber);
            }
        };
    }

    private int anyFreeLocalPortInRange(int from, int to) {
        int candidate;
        while (!this.isFree(candidate = (int)(Math.random() * (double)(to - from) + (double)from))) {
        }
        return candidate;
    }

    private boolean isFree(int port) {
        try {
            ServerSocket ss = new ServerSocket(port);
            ss.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }
}

